% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determinant_selection_table.R,
%   R/potential_for_change_index.R, R/room_for_improvement.R
\name{determinant_selection_table}
\alias{determinant_selection_table}
\alias{determinantSelectionTable_partial}
\alias{knit_print.determinantSelectionTable}
\alias{print.determinantSelectionTable}
\alias{potential_for_change_index}
\alias{P_delta}
\alias{intervention_potential}
\alias{room_for_improvement}
\title{Potential for Change Index and the Determinant Selection Table}
\usage{
determinant_selection_table(
  data,
  determinants,
  target,
  determinantLabels = NULL,
  targetLabel = NULL,
  sortBy = NULL,
  decreasing = TRUE,
  digits = 3,
  increasesAreImprovements = TRUE,
  minimum = base::min,
  maximum = base::max,
  center = base::mean,
  weight = stats::cor,
  type = NULL,
  minimumArgs = list(na.rm = TRUE),
  maximumArgs = list(na.rm = TRUE),
  centerArgs = list(na.rm = TRUE),
  weightArgs = list(use = "complete.obs"),
  potentialScale = NULL,
  headingLevel = 3,
  output = behaviorchange::opts$get("tableOutput")
)

determinantSelectionTable_partial(
  x,
  digits = attr(x, "digits"),
  headingLevel = attr(x, "headingLevel"),
  echoPartial = FALSE,
  partialFile = NULL,
  quiet = TRUE,
  ...
)

\method{knit_print}{determinantSelectionTable}(
  x,
  digits = attr(x, "digits"),
  headingLevel = attr(x, "headingLevel"),
  echoPartial = FALSE,
  partialFile = NULL,
  quiet = TRUE,
  ...
)

\method{print}{determinantSelectionTable}(
  x,
  digits = attr(x, "digits"),
  headingLevel = attr(x, "headingLevel"),
  output = attr(x, "output"),
  forceKnitrOutput = FALSE,
  ...
)

potential_for_change_index(
  data,
  determinants,
  target,
  increasesAreImprovements = TRUE,
  sampleLevel = FALSE,
  minimum = base::min,
  maximum = base::max,
  center = base::mean,
  weight = stats::cor,
  type = NULL,
  minimumArgs = list(na.rm = TRUE),
  maximumArgs = list(na.rm = TRUE),
  centerArgs = list(na.rm = TRUE),
  weightArgs = list(use = "complete.obs")
)

room_for_improvement(
  x,
  increasesAreImprovements = TRUE,
  sampleLevel = FALSE,
  minimum = base::min,
  maximum = base::max,
  center = base::mean,
  minimumArgs = list(na.rm = TRUE),
  maximumArgs = list(na.rm = TRUE),
  centerArgs = list(na.rm = TRUE),
  varName = NULL
)
}
\arguments{
\item{data}{The dataframe containing the variables.}

\item{determinants}{The name(s) of the determinant(s).}

\item{target}{The target (e.g. behavior or intention).}

\item{determinantLabels, targetLabel}{Optionally, labels to use for the
(sub-)determinants and the target. The \code{determinantLabels} must have the
same order as the \code{determinants} vector.}

\item{sortBy}{The column to sort the results by; if not \code{NULL}, a number
from 1-6 that corresponds to the six columns of the Determinant Selection
Table.}

\item{decreasing}{Whether to sort in decreasing (\code{TRUE}) or increasing
(\code{FALSE}) order.}

\item{digits}{The number of digits to round to.}

\item{increasesAreImprovements}{Whether increases are improvements (\code{TRUE})
or decreases are improvements (\code{FALSE}).}

\item{minimum, maximum}{The minimum and maximum, as functions that take
a vector and return the minimum and maximum scores, as numbers, or as
vectors of numbers specifying the minimum and maximum to use for each
column in \code{x} or \code{determinants}, or a lists of functions specifying the functions to use
for each column in \code{x} or \code{determinants}.}

\item{center}{For the sample-level version, a function that takes a
vector and returns the center (e.g. mean, median, etc), or a list of
functions specifying the function to use for each column in \code{x} or
\code{determinants}.}

\item{weight}{The function to return the weight/multiplier to use in the
computation.}

\item{type}{The type of potential for change index. Currently implemented
are type \code{'1'} and type \code{'2'} - see details for more information.}

\item{minimumArgs, maximumArgs, centerArgs, weightArgs}{lists with arguments
to pass to the corresponding functions. Note that these are not vectorized.}

\item{potentialScale}{The scale with minimum and maximum possible values
for the Potential for Change index. If \code{NULL}, the minimum is set to \code{0}
and the maximum is set to the highest observed value.}

\item{headingLevel}{The number of hashes to print in front of the headings
when printing while knitting}

\item{output}{Whether to only output to the viewer (if possible;
\code{output='viewer'}), or only to the console (\code{output='console'}), or to
both (\code{output=c('viewer', 'console')}). Note that displaying in the viewer
requires the \code{htmltools} package.}

\item{x}{For room for improvement, either a numeric vector with scores on
a (sub-)determinant, or a data frame with multiple such vectors. For the
Determinant Selection Table functions, the object to print/knit.}

\item{echoPartial}{Whether to show the executed code in the R Markdown
partial (\code{TRUE}) or not (\code{FALSE}).}

\item{partialFile}{This can be used to specify a custom partial file. The
file will have object \code{x} available.}

\item{quiet}{Passed on to \code{\link[knitr:knit]{knitr::knit()}} whether it should e
chatty (\code{FALSE}) or quiet (\code{TRUE}).}

\item{...}{Any additional arguments are passed to the default print method
by the print method, and to \code{\link[rmdpartials:partial]{rmdpartials::partial()}} when knitting a
RMarkdown partial.}

\item{forceKnitrOutput}{Force knitr output.}

\item{sampleLevel}{Whether to return sample-level estimates (\code{TRUE}) or
individual-level estimates (\code{FALSE}).}

\item{varName}{For internal use.}
}
\value{
For the individual-level version, a vector or data
frame with the same dimensions as provided; for the sample-level version, if
a vector is provided, a single number, and if a data frame is provided, a
vector with as many values as the data frame has columns. For
Determinant Selection Table, a data frame.
}
\description{
These functions compute the Potential for Change Index for one or multiple
(sub-)determinants, the room for improvement (an intermediate estimate),
and produce a convenient table with an overview of all (sub-)determinants.
Note that for determinant selection purposes, quantitative estimates such
as the Potential for Change Index should never be used without also
thoroughly inspecting the visualisations of the univariate distributions
and the confidence intervals for the associations to the ultimate
intervention targets (usually the target behavior or a proxy measure). For
this purpose, the Confidence Interval-Based Estimation of Relevance plots
can be used (see \code{\link[=CIBER]{CIBER()}}).
}
\details{
The Potential for Change index was developed by Keegan et al. and is a
numerical representation of a number of important features in \code{\link[=CIBER]{CIBER()}}
plots (for more details, please see the references below). It turned out
a similar measure, the Intervention Potential, was developed by Huber &
Mosler (2013). The latter uses regression coefficients as weights, which
is problematic for a number of reasons (see Crutzen, Peters & Noijen, 2017),
and has therefore not been implemented as a default, but it is possible to
use regression coefficients by specifying a custom weight function.

The original Potential for Change Index was conceptualized to optimize
intervention tailoring and improve the prediction of individual-level
intervention effectiveness. A second conceptualization of the Potential
for Change Index can facilitate sub-determinant selection.

In addition to using the \code{minimum}, \code{maximum}, \code{center}, and \code{weight}
functions to specify custom functions, specific types have also been
implemented to quickly use a prespecified combination of functions.

The first (\code{type = '1'}) is computed as follows:
\itemize{
\item For sub-determinants with a positive zero-order correlation with
behavior, the sample mean is subtracted from the observed maximum score,
and the result is multiplied by the zero-order correlation;
\item For sub-determinants with a negative zero-order correlation with
behavior, the sample mean is subtracted from the observed minimum score,
and the result is multiplied by the zero-order correlation.
}

The second (\code{type = '2'}) is computed as follows:
\itemize{
\item For sub-determinants with a positive zero-order correlation with
behavior, the sample mean is subtracted from the .95 quantile of the
scores, and the result is multiplied by the squared zero-order
correlation (i.e. the proportion of explained variance);
\item For sub-determinants with a negative zero-order correlation with
behavior, the sample mean is subtracted from the .05 quantile of the
scores, and the result is multiplied by the squared zero-order
correlation (i.e. the proportion of explained variance);
}

The second variant effectively takes the 5\% trimmed maximum and minimum,
rendering it less sensitive to outliers, penalizes weak associations with
behavior more severely, and decreases sensitivity to differences between
correlations. These differences should render the second variant a bit more
robust over different samples.

The room for improvement is one of the ingredients of the Potential
for Change Index or P_delta, a generalized version of the Intervention
Potential. The Determinant Selection Table efficiently presents the
Potential for Change Indices for a set of (sub-)determinants.
}
\examples{
### Get example data
dat <- get(data("BBC_pp15.1", package="behaviorchange"));

### Individual-level version, for one sub-determinant
P_delta_example <-
  behaviorchange::potential_for_change_index(
    data=dat,
    determinants='highDose_attitude',
    target='highDose_intention'
  );

head(P_delta_example);
hist(P_delta_example);

### Sample-level version
behaviorchange::potential_for_change_index(
  data=dat,
  determinants='highDose_attitude',
  target='highDose_intention',
  sampleLevel = TRUE
);

### Individual-level for multiple determinants
P_delta_example <-
  behaviorchange::potential_for_change_index(
    data=dat,
    determinants=c('highDose_attitude', 'highDose_perceivedNorm'),
    target='highDose_intention'
  );
head(P_delta_example);

### Sample-level version for multiple determinants
behaviorchange::potential_for_change_index(
  data=dat,
  determinants=c('highDose_attitude', 'highDose_perceivedNorm'),
  target='highDose_intention',
  sampleLevel = TRUE
);

### Get the Potential for Change Index Type 2
behaviorchange::potential_for_change_index(
  data=dat,
  determinants=c('highDose_attitude', 'highDose_perceivedNorm'),
  target='highDose_intention',
  type = '2',
  sampleLevel = TRUE
);

### Get a Determinant Selection Table
behaviorchange::determinant_selection_table(
  data=dat,
  determinants = c('highDose_AttBeliefs_long',
                   'highDose_AttBeliefs_intensity',
                   'highDose_AttBeliefs_euphoria'),
  target = 'highDose_intention',
  sortBy = 6
);

### R Markdown partials can smoothly be included in RMarkdown documents
behaviorchange::determinantSelectionTable_partial(
  behaviorchange::determinant_selection_table(
    data=dat,
    determinants = c('highDose_AttBeliefs_long',
                     'highDose_AttBeliefs_intensity',
                     'highDose_AttBeliefs_euphoria'),
    target = 'highDose_intention',
    sortBy = 6
  )
);

### Room for improvement for one variable
head(
  room_for_improvement(
    dat$highDose_AttBeliefs_long
  )
);

room_for_improvement(
  dat$highDose_AttBeliefs_long,
  sampleLevel = TRUE
);

### For multiple (sub-)determinants
head(
  room_for_improvement(
    dat[, c('highDose_AttBeliefs_long',
            'highDose_AttBeliefs_intensity',
            'highDose_AttBeliefs_euphoria')]
  )
);

room_for_improvement(
  dat[, c('highDose_AttBeliefs_long',
          'highDose_AttBeliefs_intensity',
          'highDose_AttBeliefs_euphoria')],
  sampleLevel = TRUE
);

}
\references{
Knittle, K. P., Peters, G.-J. Y., Heino, M. T. J., Tobias, R., &
Hankonen, N. (2019). Potential for change: New metrics for tailoring and
predicting response to behavior change interventions. \doi{10/ghqmg3}

Huber, A. C. & Mosler, H.-J. (2013) Determining behavioral factors for
interventions to increase safe water consumption: a cross-sectional field
study in rural Ethiopia, International Journal of Environmental Health
Research, 23:2, 96-107 \doi{10.1080/09603123.2012.699032}
}
