% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_alignment_ids.R
\name{get_alignment_ids}
\alias{get_alignment_ids}
\title{Get the alignment IDs from one or more files.}
\usage{
get_alignment_ids(filenames)
}
\arguments{
\item{filenames}{names of the files to be checked}
}
\value{
the IDs extracted from the one or more files
}
\description{
This is done in the same way as BEAST2 does by default
The file extension will be used to determine which
type of file is worked on.
}
\examples{
check_empty_beautier_folder()

get_alignment_ids(
  get_beautier_paths(c("anthus_aco.fas", "anthus_nd2.fas"))
)

check_empty_beautier_folder()
}
\seealso{
Use \link{get_alignment_ids_from_fasta_filenames} to
get the alignment IDs from files known to be FASTA files
}
\author{
Richèl J.C. Bilderbeek
}
