% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrca_priors_to_xml_distr.R
\name{mrca_priors_to_xml_prior_distr}
\alias{mrca_priors_to_xml_prior_distr}
\title{Creates the the \code{distribution}'s prior section (which is part of
a posterior distribution section) of a BEAST2 XML parameter file.}
\usage{
mrca_priors_to_xml_prior_distr(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
lines of XML text
}
\description{
These lines start with '\code{<distribution id="prior"}'
}
\details{
\code{
   <distribution id="posterior" spec="util.CompoundDistribution">
       <distribution id="prior" spec="util.CompoundDistribution">
         HERE, where the ID of the distribution is 'prior'
       </distribution>
       <distribution id="likelihood" ...>
       </distribution>
  </distribution>
}
}
\author{
Richèl J.C. Bilderbeek
}
