% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_laplace_distr}
\alias{create_laplace_distr}
\alias{create_distr_laplace}
\title{Create a Laplace distribution}
\usage{
create_laplace_distr(
  id = NA,
  mu = 0,
  scale = 1,
  value = NA,
  lower = NA,
  upper = NA
)
}
\arguments{
\item{id}{the distribution's ID}

\item{mu}{the mu parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_mu_param}}}

\item{scale}{the scale parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_scale_param}}}

\item{value}{the initial value for the MCMC}

\item{lower}{the lower bound, the lowest possible value}

\item{upper}{an upper limit of the uniform distribution.
If the upper limits needs to be infinity, set \code{upper} to \code{Inf}.}
}
\value{
a Laplace distribution
}
\description{
Create a Laplace distribution
}
\examples{
check_empty_beautier_folder()

laplace_distr <- create_laplace_distr()

beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  beast2_input_file,
  tree_prior = create_yule_tree_prior(
    birth_rate_distr = laplace_distr
  )
)
file.remove(beast2_input_file)

remove_beautier_folder()
check_empty_beautier_folder()
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richèl J.C. Bilderbeek
}
