% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gamma_site_model_n_distrs.R
\name{get_gamma_site_model_n_distrs}
\alias{get_gamma_site_model_n_distrs}
\title{Get the number of distributions in a gamma site model}
\usage{
get_gamma_site_model_n_distrs(gamma_site_model)
}
\arguments{
\item{gamma_site_model}{a site model's gamma site model,
as returned by \code{\link{create_gamma_site_model}}}
}
\value{
the number of distributions a gamma site model has
}
\description{
Get the number of distributions in a gamma site model
}
\examples{
check_empty_beautier_folder()

# zero distributions
gamma_site_model <- create_gamma_site_model()
get_gamma_site_model_n_distrs(
  gamma_site_model
)

gamma_site_model <- create_gamma_site_model(
 gamma_cat_count = 2,
 gamma_shape_prior_distr = create_exp_distr()
)

# one distribution
get_gamma_site_model_n_distrs(gamma_site_model)

check_empty_beautier_folder()
}
\seealso{
Use \link{create_gamma_site_model} to create a gamma site model
}
\author{
Richèl J.C. Bilderbeek
}
