% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_default_mcmc.R
\name{is_default_mcmc}
\alias{is_default_mcmc}
\title{Determine if the MCMC is a default MCMC}
\usage{
is_default_mcmc(mcmc)
}
\arguments{
\item{mcmc}{one MCMC
as returned by \code{\link{create_mcmc}}}
}
\value{
TRUE if the MCMC is a default MCMC
}
\description{
Determine if the MCMC is a default MCMC
}
\examples{
library(testthat)

 # An MCMC created by 'create_mcmc' is default
expect_true(is_default_mcmc(create_mcmc()))

# An MCMC created by 'create_ns_mcmc' is not
expect_false(is_default_mcmc(create_ns_mcmc()))
}
\author{
Richèl J.C. Bilderbeek
}
