% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree_prior.R
\name{create_bd_tree_prior}
\alias{create_bd_tree_prior}
\alias{create_tree_prior_bd}
\title{Create a Birth-Death tree prior}
\usage{
create_bd_tree_prior(
  id = NA,
  birth_rate_distr = create_uniform_distr(),
  death_rate_distr = create_uniform_distr()
)
}
\arguments{
\item{id}{the ID of the alignment}

\item{birth_rate_distr}{the birth rate distribution,
as created by a \code{\link{create_distr}} function}

\item{death_rate_distr}{the death rate distribution,
as created by a \code{\link{create_distr}} function}
}
\value{
a Birth-Death tree_prior
}
\description{
Create a Birth-Death tree prior
}
\examples{
  bd_tree_prior <- create_bd_tree_prior()

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_bd_tree_prior.xml",
    tree_priors = bd_tree_prior
  )
  testit::assert(file.exists("create_bd_tree_prior.xml"))

  bd_tree_prior_exp <- create_bd_tree_prior(
    birth_rate_distr = create_exp_distr()
  )

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_bd_tree_prior_exp.xml",
    tree_priors = bd_tree_prior_exp
  )
  testit::assert(file.exists("create_bd_tree_prior_exp.xml"))
}
\seealso{
An alignment ID can be extracted from
  its FASTA filesname using \code{\link{get_id}}
}
\author{
Richel J.C. Bilderbeek
}
