% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_duplicate_param_ids.R
\name{get_duplicate_param_ids}
\alias{get_duplicate_param_ids}
\title{Find duplicate \code{RealParameter} IDs}
\usage{
get_duplicate_param_ids(text)
}
\arguments{
\item{text}{the XML as text}
}
\value{
a vector of duplicate IDs, will be empty if all IDs are unique
}
\description{
Find duplicate \code{RealParameter} IDs
}
\examples{
check_empty_beaustier_folders()

line_1 <- "<parameter id=\"RealParameter.1\" ...</parameter>"
line_2 <- "<parameter id=\"RealParameter.2\" ...</parameter>"
# No elements
get_duplicate_param_ids(c(line_1, line_2))

# 'RealParameter.1'
get_duplicate_param_ids(c(line_1, line_1))

# 'RealParameter.2'
get_duplicate_param_ids(c(line_2, line_2))

check_empty_beaustier_folders()
}
\seealso{
to see if all IDs are unique, use \code{\link{has_unique_ids}}
}
\author{
Richèl J.C. Bilderbeek
}
