% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEM_matrices.R
\name{exogenous_matrix}
\alias{exogenous_matrix}
\title{Matrix with exogenous variables for SEM representation}
\usage{
exogenous_matrix(df, timestamp_col, entity_col, dep_var_col)
}
\arguments{
\item{df}{Data frame with data for the SEM analysis.}

\item{timestamp_col}{Column which determines time periods. For now only
natural numbers can be used as timestamps}

\item{entity_col}{Column which determines entities (e.g. countries, people)}

\item{dep_var_col}{Column with dependent variable}
}
\value{
Matrix of size N x k+1 where N is the number of entities considered and k is
the number of chosen regressors
}
\description{
Create matrix which contains exogenous variables used in the Simultaneous
Equations Model (SEM) representation. Currently these are: dependent variable
from the lowest time stamp and regressors from the second lowest time stamp.
The matrix is then used to compute likelihood for SEM analysis.
}
\examples{
set.seed(1)
df <- data.frame(
  entities = rep(1:4, 5),
  times = rep(seq(1960, 2000, 10), each = 4),
  dep_var = stats::rnorm(20), a = stats::rnorm(20), b = stats::rnorm(20)
)
exogenous_matrix(df, times, entities, dep_var)
}
