% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_space.R
\name{regressor_names_from_params_vector}
\alias{regressor_names_from_params_vector}
\title{Helper function to extract names from a vector defining a model}
\usage{
regressor_names_from_params_vector(params)
}
\arguments{
\item{params}{a vector with parameters describing the model}
}
\value{
Names of regressors which are assumed to be linearly connected with dependent
variable within the model described by the \code{params} vector.
}
\description{
For now it is assumed that we can only exclude linear relationships between
regressors and the dependent variable.
}
\details{
The vector needs to have named rows, i.e. it is assumed it comes from a
model space (see \link[bdsm]{initialize_model_space} for details).
}
\examples{
params <- c(alpha = 1, beta_gdp = 1, beta_gdp_lagged = 1, phi_0 = 1, err_var = 1)
regressor_names_from_params_vector(params)

}
