% Generated by roxygen2 (4.0.2): do not edit by hand
\name{scale_x_bd}
\alias{scale_x_bd}
\title{Weekend and holiday ignoring position scale for a ggplot.}
\usage{
scale_x_bd(..., business.dates, max.major.breaks = 5,
  max.minor.breaks = max.major.breaks * 5,
  breaks = bd_breaks(business.dates))
}
\arguments{
\item{...}{other arguments passed to \code{\link[ggplot2]{continuous_scale}}}

\item{business.dates}{a vector of \code{Date} objects, sorted ascending}

\item{max.major.breaks}{maximum major breaks \code{\link{bd_breaks}} will return, default=5}

\item{max.minor.breaks}{maximum minor breaks \code{\link{bd_breaks}} will return, default=major*5}

\item{breaks}{a function \code{max => [date range] => breaks}}
}
\description{
Weekend and holiday ignoring position scale for a ggplot.
}
\examples{
## Not run:

require(dplyr, quietly=TRUE, warn.conflicts=FALSE)
require(ggplot2, quietly=TRUE)
require(scales)

nyse <- yahoo()

set.seed(12345)
df <- data.frame(date=nyse, price=cumsum(rnorm(length(nyse))) + 100)

plot <- df \%>\% filter(as.Date('2014-08-01') <= date & date <= as.Date('2014-10-08')) \%>\% 
  ggplot(aes(x=date, y=price)) + geom_step() + 
  theme(axis.title.x=element_blank(), axis.title.y=element_blank())

plot + ggtitle('calendar dates')

# ggsave(file='man/figures/calendar.PNG', width=6, height=2)

plot + scale_x_bd(business.dates=nyse, labels=date_format("\%b '\%y")) + 
  ggtitle('business dates, month breaks')

# ggsave(file='man/figures/business.month.PNG', width=6, height=2)

plot + scale_x_bd(business.dates=nyse, max.major.breaks=10, labels=date_format('\%b \%d')) + 
  ggtitle('business dates, week breaks')

# ggsave(file='man/figures/business.week.PNG', width=6, height=2)

options <- c('2014-08-15', '2014-09-19') \%>\% as.Date

plot + 
  geom_vline(xintercept=as.numeric(options), size=2, alpha=0.25) + 
  ggtitle('calendar dates, option expiry')

# ggsave(file='man/figures/calendar.options.PNG', width=6, height=2)

plot + 
  geom_vline(xintercept=bd2t(options, business.dates=nyse), size=2, alpha=0.25) + 
  scale_x_bd(business.dates=nyse) +
  ggtitle('business dates, option expiry')

# ggsave(file='man/figures/business.options.PNG', width=6, height=2)

## End(Not run)
}

