% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plm_methods.R
\name{plot_fun}
\alias{plot_fun}
\title{Plot bdrc model objects}
\usage{
plot_fun(
  x,
  type = "rating_curve",
  param = NULL,
  transformed = FALSE,
  title = NULL,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class "plm0", "plm", "gplm0" or "gplm".}

\item{type}{A character denoting what type of plot should be drawn. Defaults to "rating_curve". Possible types are:
\describe{
  \item{\code{rating_curve}}{Plots the rating curve.}
  \item{\code{rating_curve_mean}}{Plots the posterior mean of the rating curve.}
  \item{\code{f}}{Plots the power-law exponent.}
  \item{\code{beta}}{Plots the random effect in the power-law exponent.}
  \item{\code{sigma_eps}}{Plots the standard deviation on the data level.}
  \item{\code{residuals}}{Plots the log residuals.}
  \item{\code{trace}}{Plots trace plots of parameters given in param.}
  \item{\code{histogram}}{Plots histograms of parameters given in param.}
  \item{\code{panel}}{Plots a 2x2 panel of plots: "rating curve", "residuals", "f" and "sigma_eps".}
}}

\item{param}{A character vector with the parameters to plot. Defaults to NULL and is only used if type is "trace" or "histogram". Allowed values are the parameters given in the model summary of x as well as "hyperparameters" or "latent_parameters" for specific groups of parameters.}

\item{transformed}{A logical value indicating whether the quantity should be plotted on a transformed scale used during the Bayesian inference. Defaults to FALSE.}

\item{title}{A character denoting the title of the plot. Defaults to NULL, i.e. no title.}

\item{xlim}{A numeric vector of length 2, denoting the limits on the x axis of the plot. Applicable for types "rating_curve", "rating_curve_mean", "f", "beta", "sigma_eps", "residuals".}

\item{ylim}{A numeric vector of length 2, denoting the limits on the y axis of the plot. Applicable for types "rating_curve", "rating_curve_mean", "f", "beta", "sigma_eps", "residuals".}
}
\value{
Returns an object of class ggplot2.
}
\description{
Visualize results from model objects in bdrc, plm0, plm, gplm0, gplm
}
\keyword{internal}
