% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericPipeline.R
\name{GenericPipeline}
\alias{GenericPipeline}
\title{Abstract super class implementing the pipelining process}
\description{
Abstract super class to establish the flow of Pipes.
}
\seealso{
\code{\link{bdpar.log}}, \code{\link{DefaultPipeline}},
         \code{\link{DynamicPipeline}}, \code{\link{Instance}},
         \code{\link{GenericPipe}}, \code{\link{\%>|\%}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GenericPipeline$new()}}
\item \href{#method-execute}{\code{GenericPipeline$execute()}}
\item \href{#method-get}{\code{GenericPipeline$get()}}
\item \href{#method-toString}{\code{GenericPipeline$toString()}}
\item \href{#method-clone}{\code{GenericPipeline$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{GenericPipeline}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipeline$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-execute"></a>}}
\if{latex}{\out{\hypertarget{method-execute}{}}}
\subsection{Method \code{execute()}}{
Function where is implemented the flow of the
\code{\link{GenericPipe}s}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipeline$execute(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
that is going to be processed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The preprocessed \code{\link{Instance}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
Gets a list with containing the set of \code{\link{GenericPipe}s}
 of the pipeline.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipeline$get()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The set of \code{\link{GenericPipe}s} containing the pipeline.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-toString"></a>}}
\if{latex}{\out{\hypertarget{method-toString}{}}}
\subsection{Method \code{toString()}}{
Returns a \code{\link{character}} representing the pipeline.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipeline$toString()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This function allows to set a place to define a \code{\link{character}}
representation of the structure of a pipeline.
}

\subsection{Returns}{
\code{\link{GenericPipeline}} \code{\link{character}} representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericPipeline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
