% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_checks.R
\name{temporal_resolution}
\alias{temporal_resolution}
\title{Clean data based on temporal resolution}
\usage{
temporal_resolution(bddata, res = "Day")
}
\arguments{
\item{bddata}{Bio diversity data in a data frame}

\item{res}{restriction of records with/without data, month, year fields}
}
\description{
Clean data based on temporal resolution
}
\section{samplePassData}{

When resolution is day, records with day specified will pass.
}

\section{sampleFailData}{

When resolution is month, records with NA/empty month specified will fail.
}

\section{targetDWCField}{

day, month, year
}

\section{checkCategory}{

temporal
}

\examples{

if(interactive()){

library(rgbif)
occdat <- occ_data(
  country = 'AU', # Country code for australia
  classKey = 359, # Class code for mammalia
  limit = 50 # Get only 50 records
)
myData <- occdat$data

responses <- taxo_level(temporal_resolution, 'Day')

}

}
