% This is a template R document file
% Distributed under GPL 3 or later

\name{edf}
\alias{edf}
\alias{edf.bdata}
\alias{edf.default}
\alias{print.edf}
\alias{plot.edf}
\alias{lines.edf}
\title{To compute the empirical distribution function.}
\description{
To compute the empirical distribution function.}
\usage{
  edf(x, weights, freq, from, to, gridsize, digits=0,
                rounding)
}
\arguments{
  \item{x}{A sample. 'NA' values will be automatically removed.}
  \item{weights}{A vector of weights of \code{x}}
  \item{freq}{A vector of frequencies of \code{x}}
  \item{from,to,gridsize}{start point, end point and size of a fine 
  grid where the EDF will be evaluated.}
  \item{digits}{integer indicating the number of decimal places that 
  \code{x} will be rounded to.  Negative values are allowed. A negative 
  number of digits means rounding to a power of ten, so for example 
  \code{digits = -2} rounds to the nearest hundred.}
  \item{rounding}{Rounding method.  Options include \code{nearest}, 
  \code{up}, \code{down}, or \code{none}.}
}
\author{
  B. Wang  \email{bwang@southalabama.edu}
}

\examples{

x = c(1:10)
(out = edf(x))
plot(out,ylim=c(0,1))
(out2 = edf(x, gridsize=15))
lines(out2, col=2)

}
\keyword{distribution}
\keyword{stats}

