% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-utils.R
\name{delete_cache}
\alias{delete_cache}
\alias{show_cached_files}
\title{View and delete cached files}
\usage{
delete_cache(files_to_delete = NULL)

show_cached_files()
}
\arguments{
\item{files_to_delete}{An optional argument to specify which files or layers should be deleted
from the cache. Defaults to deleting all files pausing for permission from user. If a subset
of files are specified, the files are immediately deleted.}
}
\value{
\code{delete_cache()}: A logical of whether the file(s) were successful deleted

\code{show_cached_files()}: a data.frame with the columns:
\itemize{
\item \code{file}, the name of the file,
\item \code{size_MB}, file size in MB,
\item \code{is_dir}, is it a directory? If you have cached tiles from the \code{\link[=cded]{cded()}} functions,
there will be a row in the data frame showing the total size
of the cded tiles cache directory.
\item \code{modified}, date and time last modified
}
}
\description{
View and delete cached files

Show the files you have in your cache
}
\examples{
\dontrun{
## See which files you have
show_cached_files()

## Delete your whole cache
delete_cache()

## Specify which files are deleted
delete_cache(c('regional_districts.rds', 'bc_cities.rds'))
}
}
