% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knnImputation.R
\name{rhoKNN}
\alias{rhoKNN}
\title{K nearest-neighbor (KNN) regression}
\usage{
rhoKNN(X, Dvec, V, K, type = c("eucli", "manha", "canber", "lagran",
  "mahala"), trace = FALSE)
}
\arguments{
\item{X}{a numeric design matrix.}

\item{Dvec}{a n * 3  binary matrix with three columns, corresponding to the three classes of the disease status. In row i, 1 in column j indicates that the i-th subject belongs to class j, with j = 1, 2, 3. A row of \code{NA} values indicates a non-verified subject.}

\item{V}{a binary vector containing the verification status (1 verified, 0 not verified).}

\item{K}{an integer value/vector, which indicates the number of nearest neighbors. It should be less than the number of the verification subjects.}

\item{type}{a distance measure.}

\item{trace}{switch for tracing estimation process. Default \code{FALSE}.}
}
\value{
\code{rhoKNN} returns a list containing the following components:
 \item{values}{estimates of the probabilities.}
 \item{X}{a design model matrix.}
 \item{K}{the number of nearest neighbors.}
 \item{type}{the chosen distance.}
}
\description{
\code{rhoKNN} uses the KNN approach to estimate the probabilities of the disease status in case of three categories.
}
\details{
\code{type} should be selected as one of \code{"eucli"}, \code{"manha"}, \code{"canber"}, \code{"lagran"}, \code{"mahala"} corresponding to Euclidean, Manhattan, Canberra, Lagrange and Mahalanobis distance. In practice, the selection of a suitable distance is typically dictated by features of the data and possible subjective evaluations. For example, if the covariates are heterogeneous with respect to their variances (which is particularly true when the variables are measured on heterogeneous scales), the choice of the Mahalanobis distance may be a good choice.

For the number of nearest neighbors, a small value of \code{K}, within the range 1-3, may be a good choice. In general, the choice of \code{K} may depend on the dimension of the feature space, and propose to use cross--validation to find \code{K} in case of high--dimensional covariate. See \code{\link{CVknn}}.
}
\examples{
data(EOC)
XX <- cbind(EOC$CA125, EOC$CA153, EOC$Age)
Dna <- preDATA(EOC$D, EOC$CA125)
Dvec.na <- Dna$Dvec

## Euclidean distance, K = 1
out.ecul.1nn <- rhoKNN(XX, Dvec.na, EOC$V, K = 1, type = "eucli")

## Manhattan distance, K = 1
out.manh.1nn <- rhoKNN(XX, Dvec.na, EOC$V, K = 1, type = "manha")

## Canberra distance, K = 3
out.canb.1nn <- rhoKNN(XX, Dvec.na, EOC$V, K = 3, type = "canber")

## Lagrange distance, K = 3
out.lagr.1nn <- rhoKNN(XX, Dvec.na, EOC$V, K = 3, type = "lagran")

## Mahalanobis distance, K = c(1,3)
out.maha.13nn <- rhoKNN(XX, Dvec.na, EOC$V, K = c(1,3), type = "mahala")

}
\references{
To Duc, K., Chiogna, M., Adimari, G. (2016): Nonparametric Estimation of ROC Surfaces Under Verification Bias. \url{https://arxiv.org/abs/1604.04656v1}. Submitted.
}
