% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-composite-regions.R
\name{get_composite_regions}
\alias{get_composite_regions}
\title{Get the area of each strata}
\usage{
get_composite_regions(strata_type = NULL)
}
\arguments{
\item{strata_type}{Stratification type to return the areas of}
}
\value{
Data frame with at least the following variables:
  \item{region}{Name of the stratum/region}
  \item{area_sq_km}{Area of the stratum/region in square kilometres}
}
\description{
\code{get_composite_regions} allows you to obtain the dataframe defining the original composite regions
  for a given stratification type.
}
\examples{

# Obtain the potential composite regions for each of the 5 stratification types
# Most useful if the user wishes to create an set of custom composite regions
#
# USGS BBS
st_comp_regions <- get_composite_regions(strata_type = "bbs_usgs")
# create new column "Great_Plains"
gpall <- rep("Outside",nrow(st_comp_regions))
gp <- which(st_comp_regions$bcr \%in\% c(11,17,18,19))
gpall[gp] <- "Inside"
st_comp_regions$Great_Plains <- gpall
# st_comp_regions can now be used as the dataframe input to the argument alt_region_names
# in generate_regional_indices,
# with "Great_Plains" as the value for the argument region


# CWS BBS
st_comp_regions <- get_composite_regions(strata_type = "bbs_cws")

# BCR
st_comp_regions <- get_composite_regions(strata_type = "bcr")

# State/Province/Territory
st_comp_regions <- get_composite_regions(strata_type = "state")

# Degree block
st_comp_regions <- get_composite_regions(strata_type = "latlong")


}
