% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{rPosteriorPredictive.CatHDP2}
\alias{rPosteriorPredictive.CatHDP2}
\title{Generate random samples from the posterior predictive distribution of a "CatHDP2" object}
\usage{
\method{rPosteriorPredictive}{CatHDP2}(obj, n = 1L, m, j, ...)
}
\arguments{
\item{obj}{A "CatHDP2" object.}

\item{n}{integer, number of samples.}

\item{m}{integer, group label.}

\item{j}{integer, subgroup label.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
integer, the categorical samples.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure:
     \deqn{G |eta \sim DP(eta,U)}
     \deqn{G_m|gamma \sim DP(gamma,G), m = 1:M}
     \deqn{pi_{mj}|G_m,alpha \sim DP(alpha,G_m), j = 1:J_m}
     \deqn{z|pi_{mj} \sim Categorical(pi_{mj})}
     \deqn{k|z,G_m \sim Categorical(G_m), \textrm{ if z is a sample from the base measure }G_m}
     \deqn{u|k,G \sim Categorical(G), \textrm{ if k is a sample from the base measure G}}
where DP(eta,U) is a Dirichlet Process on positive integers, eta is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G) is a Dirichlet Process on integers with concentration parameter gamma and base measure G. DP(alpha,G_m) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_m. Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatHDP2, u, z and k can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatHDP2" object. \cr
Posterior predictive is a distribution of u,z,k|alpha,gamm,eta,U.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatHDP2}}, \code{\link{dPosteriorPredictive.CatHDP2}}
}
