% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma_Inference.r
\name{dInvWishart}
\alias{dInvWishart}
\title{Density function of Inverse-Wishart distribution}
\usage{
dInvWishart(x, df, scale, LOG = TRUE)
}
\arguments{
\item{x}{matrix, a symmetric positive-definite matrix.}

\item{df}{numeric, the degree of freedom.}

\item{scale}{matrix, a symmetric positive-definite matrix, the 'scale' parameter. The 'rate' parameter in Wishart is the 'scale' parameter in InvWishart.}

\item{LOG}{logical, return log density of LOG=TRUE, default TRUE.}
}
\value{
A numeric vector, the density values.
}
\description{
For a random matrix x, The density function of Inverse-Wishart distribution is defined as:
  \deqn{(2^{(df p)/2} Gamma_p(df/2) |scale|^{-df/2})^{-1} |x|^{(-df-p-1)/2} exp(-1/2 tr(x^{-1} scale))}
Where x is a pxp symmetric positive definite matrix, Gamma_p() is the multivariate Gamma function of dimension p.
}
\examples{
x <- crossprod(matrix(rnorm(15),5,3)) #generate a symmetric positive-definite matrix
scale <- crossprod(matrix(rnorm(15),5,3)) #the prior scale of x
dInvWishart(x,df = 5,scale = scale,LOG = TRUE)
dInvWishart(x,df = 5,scale = scale,LOG = FALSE)
}
\references{
Wishart, John. "The generalized product moment distribution in samples from a normal multivariate population." Biometrika (1928): 32-52.

MARolA, K. V., JT KBNT, and J. M. Bibly. Multivariate analysis. AcadeInic Press, Londres, 1979.
}
