% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{sufficientStatistics.GaussianNIW}
\alias{sufficientStatistics.GaussianNIW}
\title{Sufficient statistics of a "GaussianNIW" object}
\usage{
\method{sufficientStatistics}{GaussianNIW}(obj, x, foreach = FALSE, ...)
}
\arguments{
\item{obj}{A "GaussianNIW" object.}

\item{x}{matrix, Gaussian samples, when x is a matrix, each row is a sample of dimension ncol(x). when x is a vector, x is length(x) samples of dimension 1.}

\item{foreach}{logical, if foreach=TRUE, will return a list of sufficient statistics for each row of x, otherwise will return the sufficient statistics of x as a whole.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
If foreach=TRUE, will return a list of sufficient statistics for each row of x, otherwise will return the sufficient statistics of x as a whole.
}
\description{
For following Gaussian-NIW model structure:
     \deqn{mu,Sigma|m,k,v,S \sim NIW(m,k,v,S)}
     \deqn{x|mu,Sigma \sim Gaussian(mu,Sigma)}
Where NIW() is the Normal-Inverse-Wishart distribution, Gaussian() is the Gaussian distribution. See \code{?dNIW} and \code{dGaussian} for the definitions of these distribution.\cr
The sufficient statistics of a set of samples x (each row of x is a sample) are: \cr
\itemize{
 \item the effective number of samples N=nrow(x)
 \item the sample sum xsum = colSums(x)
 \item the uncentered scatter matrix S = t(x)%*%x
}
}
\examples{
x <- rGaussian(10,mu = c(-1.5,1.5),Sigma = matrix(c(0.1,0.03,0.03,0.1),2,2))
obj <- GaussianNIW()                    #an GaussianNIW object
sufficientStatistics(obj=obj,x=x,foreach = FALSE)
sufficientStatistics(obj=obj,x=x,foreach = TRUE)
}
\references{
Murphy, Kevin P. "Conjugate Bayesian analysis of the Gaussian distribution." def 1.22 (2007): 16.

Gelman, Andrew, et al. "Bayesian Data Analysis Chapman & Hall." CRC Texts in Statistical Science (2004).
}
\seealso{
\code{\link{GaussianNIW}}, \code{\link{sufficientStatistics_Weighted.GaussianNIW}}
}
