% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{marginalLikelihood_bySufficientStatistics.GaussianGaussian}
\alias{marginalLikelihood_bySufficientStatistics.GaussianGaussian}
\title{Marginal likelihood of a "GaussianGaussian" object, using sufficient statistics}
\usage{
\method{marginalLikelihood_bySufficientStatistics}{GaussianGaussian}(obj, ss, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianGaussian" object.}

\item{ss}{Sufficient statistics of x. In Gaussian-Gaussian case the sufficient statistic of sample x is a object of type "ssGaussianMean", it can be  generated by the function sufficientStatistics().}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the marginal likelihood.
}
\description{
Generate the marginal likelihood of the following model structure:
     \deqn{x ~ Gaussian(mu,Sigma)}
     \deqn{mu ~ Gaussian(m,S)}
Where Sigma is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
The model structure and prior parameters are stored in a "GaussianGaussian" object. \cr
Marginal likelihood = p(x|m,S,Sigma)
}
\seealso{
\code{\link{GaussianGaussian}}, \code{\link{marginalLikelihood.GaussianGaussian}}
}
