% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{dPosterior}
\alias{dPosterior}
\title{Get the density from the posterior distribution.}
\usage{
dPosterior(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
numeric, the density value
}
\description{
This is a generic function that will generate the the density value of the posterior distribution. i.e. for the model structure: \cr
     \deqn{theta|gamma ~ H(gamma)}
     \deqn{x|theta ~ F(theta)}
get the probability density/mass from the distribution \eqn{theta ~ H(gamma)}.
For a given Bayesian bricks object obj and an observation of theta, \code{dPosterior()} will calculate the density value for different model structures:
\subsection{class(obj)="LinearGaussianGaussian"}{
Where
     \deqn{x ~ Gaussian(A z + b, Sigma)}
     \deqn{z ~ Gaussian(m,S)}
\code{dPosterior()} will return p(theta|m,S)
See \code{?dPosterior.LinearGaussianGaussian} for details.
}
\subsection{class(obj)="GaussianGaussian"}{
Where
\deqn{x ~ Gaussian(mu,Sigma)}
\deqn{mu ~ Gaussian(m,S)}
Sigma is known.
\code{dPosterior()} will return p(mu|m,S)
See \code{?dPosterior.GaussianGaussian} for details.
}
\subsection{class(obj)="GaussianInvWishart"}{
Where
\deqn{x ~ Gaussian(mu,Sigma)}
\deqn{Sigma ~ InvWishart(v,S)}
mu is known.
\code{dPosterior()} will return p(Sigma|v,S)
See \code{?dPosterior.GaussianInvWishart} for details.
}
\subsection{class(obj)="GaussianNIW"}{
Where
\deqn{x ~ Gaussian(mu,Sigma)}
\deqn{Sigma ~ InvWishart(v,S)}
\deqn{mu ~ Gaussian(m,Sigma/k)}
\code{dPosterior()} will return p(mu,Sigma|m,k,v,S)
See \code{?dPosterior.GaussianNIW} for details.
}
\subsection{class(obj)="GaussianNIG"}{
Where
\deqn{x ~ Gaussian(X beta,sigma^2)}
\deqn{sigma^2 ~ InvGamma(a,b)}
\deqn{beta ~ Gaussian(m,sigma^2 V)}
X is a row vector, or a design matrix where each row is an obervation.
\code{dPosterior()} will return p(beta,sigma^2|m,V,a,b)
See \code{?dPosterior.GaussianNIG} for details.
}
\subsection{class(obj)="CatDirichlet"}{
Where
\deqn{x ~ Categorical(pi)}
\deqn{pi ~ Dirichlet(alpha)}
\code{dPosterior()} will return p(pi|alpha)
See \code{?dPosterior.CatDirichlet} for details.
}
}
\seealso{
\code{\link{dPosterior.LinearGaussianGaussian}} for Linear Gaussian and Gaussian conjugate structure, \code{\link{dPosterior.GaussianGaussian}} for Gaussian-Gaussian conjugate structure, \code{\link{dPosterior.GaussianInvWishart}} for Gaussian-Inverse-Wishart conjugate structure, \code{\link{dPosterior.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{dPosterior.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{dPosterior.CatDirichlet}} for Categorical-Dirichlet conjugate structure ...
}
