% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerFocusSearch.R
\name{mlr_optimizers_focus_search}
\alias{mlr_optimizers_focus_search}
\alias{OptimizerFocusSearch}
\title{Optimization via Focus Search}
\description{
\code{OptimizerFocusSearch} class that implements a Focus Search.

Focus Search starts with evaluating \code{n_points} drawn uniformly at random.
For 1 to \code{maxit} batches, \code{n_points} are then drawn uniformly at random and
if the best value of a batch outperforms the previous best value over all
batches evaluated so far, the search space is shrinked around this new best
point prior to the next batch being sampled and evaluated.

For details on the shrinking, see \link{shrink_ps}.

Depending on the \link{Terminator} this procedure simply restarts after \code{maxit} is
reached.
}
\section{Dictionary}{

This \link{Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_optimizers} or with the associated sugar function \code{\link[=opt]{opt()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_optimizers$get("focus_search")
opt("focus_search")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{n_points}}{\code{integer(1)}\cr
Number of points to evaluate in each random search batch.}
\item{\code{maxit}}{\code{integer(1)}\cr
Number of random search batches to run.}
}
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
search_space = domain = ps(x = p_dbl(lower = -1, upper = 1))

codomain = ps(y = p_dbl(tags = "minimize"))

objective_function = function(xs) {
  list(y = as.numeric(xs)^2)
}

objective = ObjectiveRFun$new(
 fun = objective_function,
 domain = domain,
 codomain = codomain)

instance = OptimInstanceSingleCrit$new(
 objective = objective,
 search_space = search_space,
 terminator = trm("evals", n_evals = 10))


optimizer = opt("focus_search")

# modifies the instance by reference
optimizer$optimize(instance)

# returns best scoring evaluation
instance$result

# allows access of data.table of full path of all evaluations
as.data.table(instance$archive$data)
}
\section{Super class}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{OptimizerFocusSearch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerFocusSearch-new}{\code{OptimizerFocusSearch$new()}}
\item \href{#method-OptimizerFocusSearch-clone}{\code{OptimizerFocusSearch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="optimize"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-optimize'><code>bbotk::Optimizer$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerFocusSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerFocusSearch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerFocusSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerFocusSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerFocusSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerFocusSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
