% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorClockTime.R
\name{mlr_terminators_clock_time}
\alias{mlr_terminators_clock_time}
\alias{TerminatorClockTime}
\title{Clock Time Terminator}
\description{
Class to terminate the optimization after a fixed time point has been reached (as reported by \code{\link[=Sys.time]{Sys.time()}}).
}
\section{Dictionary}{

This \link{Terminator} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link{mlr_terminators} or with the associated
sugar function \code{\link[=trm]{trm()}}:\preformatted{mlr_terminators$get("clock_time")
trm("clock_time")
}
}

\section{Parameters}{

\describe{
\item{\code{stop_time}}{\code{POSIXct(1)}\cr
Terminator stops after this point in time.}
}
}

\examples{
stop_time = as.POSIXct("2030-01-01 00:00:00")
trm("clock_time", stop_time = stop_time)
}
\seealso{
Other Terminator: 
\code{\link{Terminator}},
\code{\link{mlr_terminators_combo}},
\code{\link{mlr_terminators_evals}},
\code{\link{mlr_terminators_none}},
\code{\link{mlr_terminators_perf_reached}},
\code{\link{mlr_terminators_run_time}},
\code{\link{mlr_terminators_stagnation_batch}},
\code{\link{mlr_terminators_stagnation}},
\code{\link{mlr_terminators}}
}
\concept{Terminator}
\section{Super class}{
\code{\link[bbotk:Terminator]{bbotk::Terminator}} -> \code{TerminatorClockTime}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TerminatorClockTime$new()}}
\item \href{#method-is_terminated}{\code{TerminatorClockTime$is_terminated()}}
\item \href{#method-clone}{\code{TerminatorClockTime$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="format">}\href{../../bbotk/html/Terminator.html#method-format}{\code{bbotk::Terminator$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="print">}\href{../../bbotk/html/Terminator.html#method-print}{\code{bbotk::Terminator$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="remaining_time">}\href{../../bbotk/html/Terminator.html#method-remaining_time}{\code{bbotk::Terminator$remaining_time()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="status">}\href{../../bbotk/html/Terminator.html#method-status}{\code{bbotk::Terminator$status()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorClockTime$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_terminated"></a>}}
\if{latex}{\out{\hypertarget{method-is_terminated}{}}}
\subsection{Method \code{is_terminated()}}{
Is \code{TRUE} iff the termination criterion is positive, and \code{FALSE}
otherwise.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorClockTime$is_terminated(archive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{archive}}{(\link{Archive}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{logical(1)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorClockTime$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
