% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.R
\name{specify_structural_restrictions}
\alias{specify_structural_restrictions}
\title{Set identifying restrictions for the structural VAR parameters.}
\usage{
specify_structural_restrictions(
  x,
  restrictions_facload = NULL,
  restrictions_B0_inv_t = NULL,
  restrictions_B0 = NULL,
  restrictions_structural_coeff = NULL,
  restrictions_long_run_ir = NULL
)
}
\arguments{
\item{x}{An object of type \code{bayesianVARs_bvar}.}

\item{restrictions_facload}{an M times r matrix of restrictions on the factor loadings.
This is equivalent to the instantaneous effects of the factor shocks.
Can only be used, if the factor decomposition for sigma was specified.}

\item{restrictions_B0_inv_t}{an M times M matrix of restrictions on the instantaneous
effects of the structural shocks. Columns correspond to shocks, rows to variables.
Can only be used, if the cholesky decomposition for sigma was specified.}

\item{restrictions_B0}{an M times M matrix of restrictions on the structural matrix.
Can only be used, if the cholesky decomposition for sigma was specified.}

\item{restrictions_structural_coeff}{a matrix of restrictions on the structural VAR coefficients.
Its size should match the dimensions of \code{x$PHI}.
Can only be used, if the cholesky decomposition for sigma was specified.}

\item{restrictions_long_run_ir}{a matrix of restrictions on the long run impulse responses.
The long run impulse responses are the sum of the impulse responses summed over all time horizons.
Restrictions on the long run impulse responses can be specified for both the factor and the
cholesky decomposition of sigma. In the case of a factor decomposition its size is expected to be
M times r. In the case of a cholesky decomposition the size must be M times M.}
}
\description{
Set identifying restrictions for the structural VAR parameters.
}
\details{
All \code{restrictions_*} entries have following meaning
\describe{
\item{NA:}{an unrestricted entry.}
\item{0:}{The entry at this position is restricted to be zero (i.e. an exclusion restriction).}
\item{A positive number:}{The sign of this entry should be positive.}
\item{A negative number:}{The sign of this entry should be negative.}
}

The structural VAR(p) model is of the following form: \deqn{\boldsymbol{y}^\prime_t \boldsymbol{B}_0
= \boldsymbol{x}^\prime_t\boldsymbol{\Phi} \boldsymbol{B}_0 + \boldsymbol{\omega}^\prime_t}
}
\examples{
train_data <- 100 * usmacro_growth[,c("GDPC1", "GDPCTPI", "GS1", "M2REAL", "CPIAUCSL")]
prior_sigma <- specify_prior_sigma(train_data, type="cholesky", cholesky_heteroscedastic=FALSE)
mod <- bvar(train_data, lags=5L, prior_sigma=prior_sigma, quiet=TRUE)

structural_restrictions <- specify_structural_restrictions(
 mod,
 restrictions_B0=rbind(
   c(1 ,NA,0 ,NA,NA),
   c(0 ,1 ,0 ,NA,NA),
   c(0 ,NA,1 ,NA,NA),
   c(0 ,0 ,NA,1 ,NA),
   c(0 ,0 ,0 ,0 ,1 )
 )
)
irf_structural <- irf(
 mod, ahead=8,
 structural_restrictions=structural_restrictions
)
plot(irf_structural)

}
\seealso{
\code{\link{irf}}, \code{\link{extractB0}}, \code{\link{specify_prior_sigma}}
}
\author{
Stefan Haan \email{sthaan@edu.aau.at}
}
