# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Completion algorithm for precision matrix estimate.  See Murph et al 2023 for explaination.
#' 
#' @noRd
#' 
complete_lambda <- function(orig_chol_mat, current_G, p, cores) {
    .Call(`_bayesWatch_complete_lambda`, orig_chol_mat, current_G, p, cores)
}

#' Single step in Lenkowski's Double Reversible Metropolis-Hastings algorithm.
#' 
#' @noRd
#' 
DRJ_MCMC_singlestep <- function(current_lambda, lambda_0, current_G, p, cores, edge_updated_i, edge_updated_j, scale_matrix, n_regime, mean_vector_regime, nS2, b, spread_parameter_sd2, mean_hyperparameter, lambda_hyperparameter, g_prior) {
    .Call(`_bayesWatch_DRJ_MCMC_singlestep`, current_lambda, lambda_0, current_G, p, cores, edge_updated_i, edge_updated_j, scale_matrix, n_regime, mean_vector_regime, nS2, b, spread_parameter_sd2, mean_hyperparameter, lambda_hyperparameter, g_prior)
}

#' Unnormalized kernel log value for a NW posterior distribution, given the data.
#' 
#' @noRd
#' 
log_dNormalWishart_posterior_unnormalized <- function(data_matrix, m_hyperparameter, scale_matrix, lambda_hyperparameter, nu_wishartDF, observed_mu, observed_precision) {
    .Call(`_bayesWatch_log_dNormalWishart_posterior_unnormalized`, data_matrix, m_hyperparameter, scale_matrix, lambda_hyperparameter, nu_wishartDF, observed_mu, observed_precision)
}

#' Unnormalized kernel log value for a NW distribution.
#' 
#' @noRd
#' 
log_dNormalWishart_unnormalized <- function(m_hyperparameter, posterior_inv_scale, lambda_hyperparameter, nu_wishartDF, observed_mu, observed_precision) {
    .Call(`_bayesWatch_log_dNormalWishart_unnormalized`, m_hyperparameter, posterior_inv_scale, lambda_hyperparameter, nu_wishartDF, observed_mu, observed_precision)
}

#' Sample a new mu according to a NW distribution.
#' 
#' @noRd
#' 
rmu_0 <- function(sigma_0, sum_precision_matrices, sum_precision_times_mu, m_hyperparameter) {
    .Call(`_bayesWatch_rmu_0`, sigma_0, sum_precision_matrices, sum_precision_times_mu, m_hyperparameter)
}

#' Calculates MH ratio for a graph update.
#' 
#' @noRd
#' 
log_MH_Gupdate_Rcpp <- function(selected_edge_i, selected_edge_j, oldG, newG, oldK, newK, b, p) {
    .Call(`_bayesWatch_log_MH_Gupdate_Rcpp`, selected_edge_i, selected_edge_j, oldG, newG, oldK, newK, b, p)
}

#' Calcuates the MH ratio for a merge split on regime vector.
#' 
#' @noRd
#' 
log_MH_mergesplit_Rcpp <- function(oldK, newK, b, p) {
    .Call(`_bayesWatch_log_MH_mergesplit_Rcpp`, oldK, newK, b, p)
}

#' Calculates probability of new regime vector according to the Markov process.
#' 
#' @noRd
#' 
log_transition_probability_HMM_Rcpp <- function(transition_probabilities, my_states, length_of_vector) {
    .Call(`_bayesWatch_log_transition_probability_HMM_Rcpp`, transition_probabilities, my_states, length_of_vector)
}

#' Selects an element of G to update according to the prior probability of edge inclusion.
#' 
#' @noRd
#' 
select_edge_from_G_prior_Rcpp <- function(G, g_prior, p) {
    .Call(`_bayesWatch_select_edge_from_G_prior_Rcpp`, G, g_prior, p)
}

#' Fast evaluation of multivariate normal log density.
#'
#' @param data_x A matrix of data instances
#' @param mean A row vector corresponding to center parameter value.
#' @param prec A matrix corresponding to precision matrix parameter value.
#'
#' @noRd
#' 
log_dmvnrm_arma_regular <- function(data_x, mean, prec) {
    .Call(`_bayesWatch_log_dmvnrm_arma_regular`, data_x, mean, prec)
}

#' Redraw latent data.
#' 
#' @noRd
#' 
redraw_Z_arma <- function(current_data, current_precision, current_mu, p, lower_bounds, upper_bounds, lower_bound_is_equal, upper_bound_is_equal, is_missing, is_continuous, raw_data, ordinal_levels, is_ordinal, discrete_levels_indicator, cores) {
    .Call(`_bayesWatch_redraw_Z_arma`, current_data, current_precision, current_mu, p, lower_bounds, upper_bounds, lower_bound_is_equal, upper_bound_is_equal, is_missing, is_continuous, raw_data, ordinal_levels, is_ordinal, discrete_levels_indicator, cores)
}

#' Redraw latent data for missing values only (not including for discrete values).
#' 
#' @noRd
#' 
redraw_Z_arma_justmissings <- function(current_data, current_precision, current_mu, p, lower_bounds, upper_bounds, lower_bound_is_equal, upper_bound_is_equal, is_missing, is_continuous, cores) {
    .Call(`_bayesWatch_redraw_Z_arma_justmissings`, current_data, current_precision, current_mu, p, lower_bounds, upper_bounds, lower_bound_is_equal, upper_bound_is_equal, is_missing, is_continuous, cores)
}

#' Fast evaluation of multivariate normal density of latent data values corresponding to missing values.
#' 
#' @noRd
#' 
get_justmissings_density <- function(current_data, current_precision, current_mu, p, lower_bounds, upper_bounds, lower_bound_is_equal, upper_bound_is_equal, is_missing, is_continuous, cores) {
    .Call(`_bayesWatch_get_justmissings_density`, current_data, current_precision, current_mu, p, lower_bounds, upper_bounds, lower_bound_is_equal, upper_bound_is_equal, is_missing, is_continuous, cores)
}

#' Calculates the normalizing constant for a G-Wishart with fixed graph structure using a Laplace approximation.
#' 
#' @noRd
#' 
log_normalizing_g_wishart_posterior_laplace <- function(graph, D_post, Delta, n, p) {
    .Call(`_bayesWatch_log_normalizing_g_wishart_posterior_laplace`, graph, D_post, Delta, n, p)
}

#' Calculates the probability of a component for the Gibbs sweep update.
#' 
#' @noRd
#' 
calc_logprob_Gibbs_comp <- function(current_precision, current_mu, regime_comp_log_probs, current_data, proposed_component) {
    .Call(`_bayesWatch_calc_logprob_Gibbs_comp`, current_precision, current_mu, regime_comp_log_probs, current_data, proposed_component)
}

#' Calculates relative probability of two possible components according to Dirichlet process.
#' 
#' @noRd
#' 
gibbs_swap_btwn_two <- function(first_precision, second_precision, first_mu, second_mu, component_log_probs, indices_of_split_component, data_points_of_state, assignments_launch, first_component, second_component, num_gibbs_sweeps) {
    .Call(`_bayesWatch_gibbs_swap_btwn_two`, first_precision, second_precision, first_mu, second_mu, component_log_probs, indices_of_split_component, data_points_of_state, assignments_launch, first_component, second_component, num_gibbs_sweeps)
}

#' Performs swap of components in the component reassignment.
#' 
#' @noRd
#' 
gibbs_swap_comps <- function(data_points_of_state, cluster_assignments, regime_comp_log_probs, precisions, mus, assignments_maximum, gibbs_sweeps) {
    .Call(`_bayesWatch_gibbs_swap_comps`, data_points_of_state, cluster_assignments, regime_comp_log_probs, precisions, mus, assignments_maximum, gibbs_sweeps)
}

#' Samples from a multivariate normal distribution.
#' 
#' @noRd
#' 
rmvn_Rcpp <- function(mus, K, p) {
    .Call(`_bayesWatch_rmvn_Rcpp`, mus, K, p)
}

#' Samples from a Wishart distribution.
#' 
#' @noRd
#' 
rwish_Rcpp <- function(Ts, b, p) {
    .Call(`_bayesWatch_rwish_Rcpp`, Ts, b, p)
}

#' Samples from a G-Wishart distribution according to the algorithm by Dobra and Lenkowski.
#' 
#' @noRd
#' 
rgwish_Rcpp <- function(G, D, b, p, threshold) {
    .Call(`_bayesWatch_rgwish_Rcpp`, G, D, b, p, threshold)
}

#' Approximates the G wishart normalizing using an MCMC algorithm.
#' 
#' @noRd
#' 
log_wishart_normalizingConstant_mc_Rcpp <- function(G, nu, b, H, check_H, mc_iters, p) {
    .Call(`_bayesWatch_log_wishart_normalizingConstant_mc_Rcpp`, G, nu, b, H, check_H, mc_iters, p)
}

