% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{loo_bgam}
\alias{loo_bgam}
\alias{loo_bgam,bayesGAMfit-method}
\alias{loo_bgam,array-method}
\title{Calls the \code{loo} package to perform efficient approximate leave-one-out cross-validation on models fit with \code{bayesGAM}}
\usage{
loo_bgam(object, ...)

\S4method{loo_bgam}{bayesGAMfit}(object, ...)

\S4method{loo_bgam}{array}(object, ...)
}
\arguments{
\item{object}{Object of type \code{bayesGAMfit} generated from \code{bayesGAM}.}

\item{...}{Additional parameters to pass to pass to \code{loo::loo}}
}
\value{
a named list of class \code{c("psis_loo", "loo")}
\describe{
\item{\code{estimates}}{
A matrix with two columns (\code{Estimate}, \code{SE}) and three rows
(\code{elpd_loo}, \code{p_loo}, \code{looic}). This
contains point estimates and standard errors of the expected log pointwise
predictive density (\code{elpd_loo}), the effective number of parameters
(\code{p_loo}) and the LOO information criterion \code{looic} (which is
just \code{-2 * elpd_loo}, i.e., converted to deviance scale).
}

\item{\code{pointwise}}{
A matrix with five columns (and number of rows equal to the number of
observations) containing the pointwise contributions of the measures
(\code{elpd_loo}, \code{mcse_elpd_loo}, \code{p_loo}, \code{looic}, \code{influence_pareto_k}).
in addition to the three measures in \code{estimates}, we also report
pointwise values of the Monte Carlo standard error of \code{elpd_loo}
(\code{mcse_elpd_loo}), and statistics describing the influence of
each observation on the posterior distribution (\code{influence_pareto_k}).
These are the estimates of the shape parameter \eqn{k} of the
generalized Pareto fit to the importance ratios for each leave-one-out
distribution. See the \link{pareto-k-diagnostic} page for details.
}

\item{\code{diagnostics}}{
A named list containing two vectors:
\itemize{
\item \code{pareto_k}: Importance sampling reliability diagnostics. By default,
these are equal to the \code{influence_pareto_k} in \code{pointwise}.
Some algorithms can improve importance sampling reliability and
modify these diagnostics. See the \link{pareto-k-diagnostic} page for details.
\item \code{n_eff}: PSIS effective sample size estimates.
}
}

\item{\code{psis_object}}{
This component will be \code{NULL} unless the \code{save_psis} argument is set to
\code{TRUE} when calling \code{loo()}. In that case \code{psis_object} will be the object
of class \code{"psis"} that is created when the \code{loo()} function calls \code{\link[=psis]{psis()}}
internally to do the PSIS procedure.
}
}
}
\description{
Computes PSIS-LOO CV, efficient approximate leave-one-out (LOO) cross-validation for
Bayesian models using Pareto smoothed importance sampling (PSIS). This calls the implementation
from the \code{loo} package of the methods described in Vehtari, Gelman, and Gabry (2017a, 2017b).
}
\examples{
f <- bayesGAM(weight ~ np(height), data = women,
              family = gaussian, iter=500, chains = 1)
loo_bgam(f)
}
\references{
Vehtari, A., Gelman, A., and Gabry, J. (2017a). Practical Bayesian model evaluation using leave-one-out cross-validation and WAIC. Statistics and Computing. 27(5), 1413–1432. doi:10.1007/s11222-016-9696-4 (journal version, preprint arXiv:1507.04544).

Vehtari, A., Gelman, A., and Gabry, J. (2017b). Pareto smoothed importance sampling. preprint arXiv:1507.02646

Vehtari A, Gabry J, Magnusson M, Yao Y, Gelman A (2019). “loo: Efficient leave-one-out cross-validation and WAIC for Bayesian models.” R package version 2.2.0, <URL: https://mc-stan.org/loo>.
}
