% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_read.R
\name{bayes_read_probs}
\alias{bayes_read_probs}
\title{Read probability maps}
\usage{
bayes_read_probs(probs_file, labels)
}
\arguments{
\item{probs_file}{Full path to raster multi-band file
containing probability matrices}

\item{labels}{Labels to be assigned to the bands}
}
\value{
A SpatRaster object
}
\description{
Read probability maps
}
\examples{
if (bayes_run_examples()) {
# Define location of a probability file
data_dir <- system.file("/extdata/probs", package = "bayesEO")
# list the file
file <- list.files(data_dir)
# build the full path
probs_file <- paste0(data_dir, "/", file)
# define labels
labels <- c("Water", "ClearCut_Burn", "ClearCut_Soil",
             "ClearCut_Veg", "Forest", "Wetland")

probs_image <- bayes_read_probs(probs_file, labels)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
