% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/success_rate_class.R
\docType{class}
\name{success_rate_class-class}
\alias{success_rate_class-class}
\alias{success_rate_class}
\title{success_rate_class}
\description{
An S4 class for storing results of successes (true/false) Bayesian model.

\strong{Functions}

summary(`success_rate_class`): prints a summary of the fit.

print(`success_rate_class`): prints a more detailed summary of the fit

show(`success_rate_class`): prints a more detailed summary of the fit.

get_parameters(`success_rate_class`): returns a dataframe with values of fitted parameters.

get_subject_parameters(`success_rate_class`): returns a dataframe with values of fitted parameters for each subject in the hierarchical model.

compare_means(`success_rate_class`, fit2=`success_rate_class`): returns difference in success rate between two groups. You can also provide the rope parameter.

compare_means(`success_rate_class`, fits=`list`): returns difference in success rate between multiple groups. You can also provide the rope parameter.

plot_means_difference(`success_rate_class`, fit2=`success_rate_class`): a visualization of the difference between two groups. You can also provide the rope and bins (number of bins in the histogram) parameters.

plot_means_difference(`success_rate_class`, fits=`list`): a visualization of the difference between multiple groups. You can also provide the rope and bins (number of bins in the histogram) parameters.

plot_means(`success_rate_class`): plots density for the first group means.

plot_means(`success_rate_class`, fit2=`success_rate_class`): plots density for the first and the second group means.

plot_means(`success_rate_class`, fits=`list`): plots density for multiple

compare_distributions(`success_rate_class`, fit2=`success_rate_class`): draws samples from distribution of the first group and compares them against samples drawn from the distribution of the second group. You can also provide the rope parameter.

compare_distributions(`success_rate_class`, fits=`list`): draws and compares samples from distributions of multiple groups. You can also provide the rope parameter.

plot_distributions(`success_rate_class`): a visualization of the fitted distribution.

plot_distributions(`success_rate_class`, fit2=`success_rate_class`): a visualization of the distribution for two fits.

plot_distributions(`success_rate_class`, fits=`list`): a visualization of the distribution for multiple fits.

plot_distributions_difference(`success_rate_class`, fit2=`success_rate_class`): a visualization of the difference between the distribution of the first group and the second group. You can also provide the rope and bins (number of bins in the histogram) parameters.

plot_distributions_difference(`success_rate_class`, fits=`list`): a visualization of the difference between the distributions of multiple groups. You can also provide the rope and bins (number of bins in the histogram) parameters.

plot_fit(`success_rate_class`): plots fitted model against the data. Use this function to explore the quality of your fit. Fit will be plotted on the group level.

plot_fit(`success_rate_class`, subjects='boolean'): plots fitted model against the data. Use this function to explore the quality of your fit. You can plot on the subjects level (subjects=TRUE) or on the group level (subjects=FALSE).

plot_trace(`success_rate_class`): traceplot for main fitted model parameters.
}
\section{Slots}{

\describe{
\item{\code{extract}}{Extract from Stan fit.}

\item{\code{fit}}{Stan fit.}

\item{\code{data}}{Data on which the fit is based.}
}}

\examples{
\donttest{
#priors
p_prior <- b_prior(family="beta", pars=c(1, 1))
tau_prior <- b_prior(family="uniform", pars=c(0, 500))

# attach priors to relevant parameters
priors <- list(c("p", p_prior),
               c("tau", tau_prior))

# subjects
s <- rep(1:5, 20)

# generate data and fit
data1 <- rbinom(100, size=1, prob=0.6)
fit1 <- b_success_rate(r=data1, s=s, priors=priors, chains=1)

data2 <- rbinom(100, size=1, prob=0.1)
fit2 <- b_success_rate(r=data2, s=s, priors=priors, chains=1)

data3 <- rbinom(100, size=1, prob=0.5)
fit3 <- b_success_rate(r=data3, s=s, priors=priors, chains=1)

data4 <- rbinom(100, size=1, prob=0.9)
fit4 <- b_success_rate(r=data4, s=s, priors=priors, chains=1)

# fit list
fit_list <- list(fit2, fit3, fit4)

# a short summary of fitted parameters
summary(fit1)

# a more detailed summary of fitted parameters
print(fit1)
show(fit1)

# extract parameter values from the fit
parameters <- get_parameters(fit1)

# extract parameter values on the bottom (subject) level from the fit
subject_parameters <- get_subject_parameters(fit1)

# compare means between two fits, use a rope interval
compare_means(fit1, fit2=fit2, rope=0.05)

# compare means between multiple fits
compare_means(fit1, fits=fit_list)

# visualize difference in means between two fits,
# specify number of histogram bins and rope interval
plot_means_difference(fit1, fit2=fit2, bins=40, rope=0.05)

# visualize difference in means between multiple fits
plot_means_difference(fit1, fits=fit_list)

# visualize means of a single fit
plot_means(fit1)

# visualize means of two fits
plot_means(fit1, fit2=fit2)

# visualize means of multiple fits
plot_means(fit1, fits=fit_list)

# draw samples from distributions underlying two fits and compare them,
# use a rope interval
compare_distributions(fit1, fit2=fit2, rope=0.05)

# draw samples from distributions underlying multiple fits and compare them
compare_distributions(fit1, fits=fit_list)

# visualize the distribution underlying a fit
plot_distributions(fit1)

# visualize distributions underlying two fits
plot_distributions(fit1, fit2=fit2)

# visualize distributions underlying multiple fits
plot_distributions(fit1, fits=fit_list)

# visualize difference between distributions underlying two fits,
# use a rope interval
plot_distributions_difference(fit1, fit2=fit2, rope=0.05)

# visualize difference between distributions underlying multiple fits
plot_distributions_difference(fit1, fits=fit_list)

# plot the fitted distribution against the data
plot_fit(fit1)

# plot the fitted distribution against the data,
# plot on the top (group) level
plot_fit(fit1, subjects=FALSE)

# traceplot of the fitted parameters
plot_trace(fit1)
}

}
