% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JobTables.R
\name{getJobTable}
\alias{getJobPars}
\alias{getJobResources}
\alias{getJobStatus}
\alias{getJobTable}
\alias{getJobTags}
\title{Query Job Information}
\usage{
getJobTable(ids = NULL, flatten = NULL, prefix = FALSE,
  reg = getDefaultRegistry())

getJobStatus(ids = NULL, reg = getDefaultRegistry())

getJobResources(ids = NULL, flatten = NULL, prefix = FALSE,
  reg = getDefaultRegistry())

getJobPars(ids = NULL, flatten = NULL, prefix = FALSE,
  reg = getDefaultRegistry())

getJobTags(ids = NULL, reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to all jobs.}

\item{flatten}{[\code{logical(1)}]\cr
Transform the job parameters and/or resource specifications to data frame columns?
Defaults to \code{TRUE} if all parameters or resources are atomics,
\code{FALSE} otherwise where each row of the column will hold a named list.
New columns will be named using \code{prefix}.}

\item{prefix}{[\code{logical(1)}]\cr
If set to \code{TRUE}, the prefix \dQuote{par.} is used to name column names of parameters
for a \code{\link{Registry}} and prefixes \dQuote{prob.par.} and \dQuote{algo.par.} are used to name
the columns of a \code{\link{ExperimentRegistry}}. Resources are prefixed with \dQuote{res.}.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{\link{data.table}}] with the following columns (not necessarily in this order):
  \describe{
    \item{job.id}{Unique Job ID as integer.}
    \item{submitted}{Time the job was submitted to the batch system as \code{\link[base]{POSIXct}}.}
    \item{started}{Time the job was started on the batch system as \code{\link[base]{POSIXct}}.}
    \item{done}{Time the job terminated (successfully or with an error) as \code{\link[base]{POSIXct}}.}
    \item{error}{Either \code{NA} if the job terminated successfully or the error message.}
    \item{memory}{Estimate of the memory usage.}
    \item{batch.id}{Batch ID as reported by the scheduler.}
    \item{job.hash}{Unique string identifying the job or chunk.}
    \item{time.queued}{Time in seconds (as \code{\link[base]{difftime}}) the job was queued.}
    \item{time.running}{Time in seconds (as \code{\link[base]{difftime}}) the job was running.}
    \item{pars}{List of parameters/arguments for this job. Possibly expanded to separate columns (see \code{prefix}.}
    \item{resources}{List of computational resources set for this job. Possibly expanded to separate columns (see \code{prefix}.}
    \item{tags}{Tags as joined string, delimited by \dQuote{,}.}
    \item{problem}{Only for \code{\link{ExperimentRegistry}}: the problem identifier.}
    \item{algorithm}{Only for \code{\link{ExperimentRegistry}}: the algorithm identifier.}
  }
}
\description{
\code{getJobStatus} returns the internal table which stores information about the computational
status of jobs, \code{getJobPars} a table with the job parameters, \code{getJobResources} a table
with the resources which were set to submit the jobs, and \code{getJobTags} the tags of the jobs
(see \link{Tags}).

\code{getJobTable} returns all these tables joined.
}
\examples{
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
f = function(x) if (x < 0) stop("x must be > 0") else sqrt(x)
batchMap(f, x = c(-1, 0, 1), reg = tmp)
submitJobs(reg = tmp)
waitForJobs(reg = tmp)

# Complete table:
getJobTable(reg = tmp, flatten = FALSE)

# Table with tags:
addJobTags(1:2, "tag1", reg = tmp)
addJobTags(2, "tag2", reg = tmp)
getJobTags(reg = tmp)

# Job parameters with tags right-joined:
rjoin(getJobPars(reg = tmp), getJobTags(reg = tmp))
}

