% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{batch_process}
\alias{batch_process}
\title{Batch File Processing}
\usage{
batch_process(
  fun,
  path,
  regexp = ".*",
  recurse = FALSE,
  progress = FALSE,
  force = TRUE,
  report = TRUE,
  seeds = NULL,
  options = furrr::furrr_options(),
  ask = getOption("batchr.ask", TRUE),
  ...
)
}
\arguments{
\item{fun}{A function to process each of the files.
\code{fun}'s first argument should be a string of the path to a single file.
If processing is unsuccessful \code{fun} should return FALSE
or throw an error (error messages are caught and automatically logged).
If fun deletes or modifies the file then it is no longer considered
for processing.}

\item{path}{A string of the path to the directory with the files for processing.}

\item{regexp}{A string of a regular expression. Only non-hidden file names
which match the regular expression will be batch processed.}

\item{recurse}{A flag specifying whether to recurse into path's subdirectories.}

\item{progress}{A flag specifying whether to print a progress bar.}

\item{force}{A flag specifying whether to delete configuration and
log files even if there are files remaining to be processed.}

\item{report}{A flag specifying whether to outputs a report of
the status of individual files to the console.}

\item{seeds}{A named list of the L'Ecuyer-CMRG seed to use for each
file. If \code{NULL} then \code{seeds} is \code{batch_seeds(files)}.}

\item{options}{The future specific options to use with the workers.
seed must be \code{FALSE}.}

\item{ask}{A flag specifying whether to ask before starting to process the files.}

\item{...}{Additional arguments passed to \code{fun}.}
}
\value{
An invisible flag indicating whether all the files where
successfully processed.
}
\description{
Performs batch processing of files in a directory using the
\code{\link[=batch_config]{batch_config()}}, \code{\link[=batch_run]{batch_run()}}
and \code{\link[=batch_cleanup]{batch_cleanup()}} functions.
For more control the user should call these three functions instead.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_process(function(x) TRUE, path, regexp = "[.]csv$", ask = FALSE)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_config]{batch_config()}}, \code{\link[=batch_run]{batch_run()}}
and \code{\link[=batch_cleanup]{batch_cleanup()}}
}
