% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{setup_fujikawa}
\alias{setup_fujikawa}
\title{Setup Fujikawa Design Object}
\usage{
setup_fujikawa(k, p0, shape1 = 1, shape2 = 1)
}
\arguments{
\item{k}{The number of baskets.}

\item{p0}{A common probability under the null hypothesis.}

\item{shape1}{First common shape parameter of the beta prior.}

\item{shape2}{Second common shape parameter of the beta prior.}
}
\value{
An S3 object of class \code{fujikawa}
}
\description{
Setup Fujikawa Design Object
}
\details{
The class \code{fujikawa} implements a design by Fujikawa et al.
(2020) in which information is shared based on the pairwise similarity
between baskets which is quantified using the Jensen-Shannon divergence
between the individual posterior distributions between baskets.
}
\examples{
design_fujikawa <- setup_fujikawa(k = 3, p0 = 0.2)
}
\references{
Fujikawa, K., Teramukai, S., Yokota, I., & Daimon, T. (2020).
A Bayesian basket trial design that borrows information across strata based
on the similarity between the posterior distributions of the response
probability. Biometrical Journal, 62(2), 330-338.
}
