% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSpower3P.R
\name{SSpower3P}
\alias{SSpower3P}
\title{Self-Starting Nls 'power3P' Regression Model}
\usage{
SSpower3P(predictor, a, b, c)
}
\arguments{
\item{predictor}{a numeric vector of values at which to evaluate the model.}

\item{a, b, c}{Three numeric parameters responsing to the exp3P model.}
}
\description{
This selfStart model evaluates the power regression function (formula as: y=a*x^b+c). It has an initial attribute that will evaluate initial estimates of the parameters a, b, and c for a given set of data.
}
\examples{
library(basicTrendline)
x<-1:5
y<-c(2,4,8,20,25)
xy<-data.frame(x,y)
getInitial(y ~ SSpower3P(x,a,b,c), data = xy)
## Initial values are in fact the converged values

fitpower3P <- nls(y~SSpower3P(x,a,b,c), data=xy)
summary(fitpower3P)

}
\seealso{
\code{\link{trendline}}, \code{\link{SSexp3P}}, \code{\link{SSpower3P}}, \code{\link[stats]{nls}}, \code{\link[stats]{selfStart}}
}
\author{
Weiping Mei \email{meiweipingg@163.com}
}
