% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_people_free_agents.R
\name{mlb_people_free_agents}
\alias{mlb_people_free_agents}
\title{\strong{Find Information About MLB Free Agents}}
\usage{
mlb_people_free_agents(season = NULL)
}
\arguments{
\item{season}{Season preceding free agency}
}
\value{
Returns a tibble with the following columns:\tabular{ll}{
   col_name \tab types \cr
   date_declared \tab character \cr
   notes \tab character \cr
   date_signed \tab character \cr
   sort_order \tab integer \cr
   player_id \tab integer \cr
   player_full_name \tab character \cr
   player_link \tab character \cr
   original_team_id \tab integer \cr
   original_team_name \tab character \cr
   original_team_link \tab character \cr
   position_code \tab character \cr
   position_name \tab character \cr
   position_type \tab character \cr
   position_abbreviation \tab character \cr
   new_team_id \tab integer \cr
   new_team_name \tab character \cr
   new_team_link \tab character \cr
}
}
\description{
\strong{Find Information About MLB Free Agents}
}
\examples{
\donttest{
  try(mlb_people_free_agents(season = 2018))
}
}
