% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_game_pace.R
\name{mlb_game_pace}
\alias{mlb_game_pace}
\title{\strong{Retrieve game pace metrics for major and minor league}}
\usage{
mlb_game_pace(
  season,
  league_ids = NULL,
  sport_ids = NULL,
  team_ids = NULL,
  game_type = NULL,
  venue_ids = NULL,
  org_type = NULL,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{season}{Year for which to return information (\emph{Required}).}

\item{league_ids}{The league_id(s) for which to return information.}

\item{sport_ids}{The sport_id(s) for which to return information.}

\item{team_ids}{The team_id(s) for which to return information.}

\item{game_type}{The game_type for which to return information.}

\item{venue_ids}{Venue directorial information based venue_id.}

\item{org_type}{pace of game metrics based on team ('T'), league ('L') or sport('S')}

\item{start_date}{Date of first game for which you want data.
Format must be in MM/DD/YYYY format.}

\item{end_date}{Date of last game for which you want data.
Format must be in MM/DD/YYYY format.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   hits_per9inn \tab numeric \cr
   runs_per9inn \tab numeric \cr
   pitches_per9inn \tab numeric \cr
   plate_appearances_per9inn \tab numeric \cr
   hits_per_game \tab numeric \cr
   runs_per_game \tab numeric \cr
   innings_played_per_game \tab numeric \cr
   pitches_per_game \tab numeric \cr
   pitchers_per_game \tab numeric \cr
   plate_appearances_per_game \tab numeric \cr
   total_game_time \tab character \cr
   total_innings_played \tab integer \cr
   total_hits \tab integer \cr
   total_runs \tab integer \cr
   total_plate_appearances \tab integer \cr
   total_pitchers \tab integer \cr
   total_pitches \tab integer \cr
   total_games \tab integer \cr
   total7inn_games \tab integer \cr
   total9inn_games \tab integer \cr
   total_extra_inn_games \tab integer \cr
   time_per_game \tab character \cr
   time_per_pitch \tab character \cr
   time_per_hit \tab character \cr
   time_per_run \tab character \cr
   time_per_plate_appearance \tab character \cr
   time_per9inn \tab character \cr
   time_per77plate_appearances \tab character \cr
   total_extra_inn_time \tab character \cr
   time_per7inn_game \tab character \cr
   time_per7inn_game_without_extra_inn \tab character \cr
   total7inn_games_scheduled \tab integer \cr
   total7inn_games_without_extra_inn \tab integer \cr
   total9inn_games_completed_early \tab integer \cr
   total9inn_games_without_extra_inn \tab integer \cr
   total9inn_games_scheduled \tab integer \cr
   hits_per_run \tab numeric \cr
   pitches_per_pitcher \tab numeric \cr
   season \tab character \cr
   sport_id \tab integer \cr
   sport_code \tab character \cr
   sport_link \tab character \cr
   pr_portal_calculated_fields_total7inn_games \tab integer \cr
   pr_portal_calculated_fields_total9inn_games \tab integer \cr
   pr_portal_calculated_fields_total_extra_inn_games \tab integer \cr
   pr_portal_calculated_fields_time_per7inn_game \tab character \cr
   pr_portal_calculated_fields_time_per9inn_game \tab character \cr
   pr_portal_calculated_fields_time_per_extra_inn_game \tab character \cr
}
}
\description{
\strong{Retrieve game pace metrics for major and minor league}
}
\examples{
\donttest{
  try(mlb_game_pace(season = 2021, start_date = "09/14/2021", end_date = "09/16/2021"))
}
}
