% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varIncProb.R
\name{varIncProb}
\alias{varIncProb}
\title{Variable inclusion probabilities as defined by Linero (2018)}
\usage{
varIncProb(object)
}
\arguments{
\item{object}{A bartBMA object obtained using the barBMA function.}
}
\value{
A vector of posterior inclusion probabilities. The variables are ordered in the same order that they occur in columns of the input covariate matrix used to obtain the input bartBMA object.
}
\description{
This measure defines the posterior inclusion probability of a variable as the model-probability weighted sum of indicator variables for whether the variable was used in any splitting rules in any of the trees in the sum-of-tree model.
}
\examples{
#set the seed
set.seed(100)
#simulate some data
N <- 100
p<- 100
epsilon <- rnorm(N)
xcov <- matrix(runif(N*p), nrow=N)
y <- sin(pi*xcov[,1]*xcov[,2]) + 20*(xcov[,3]-0.5)^2+10*xcov[,4]+5*xcov[,5]+epsilon
epsilontest <- rnorm(N)
xcovtest <- matrix(runif(N*p), nrow=N)
ytest <- sin(pi*xcovtest[,1]*xcovtest[,2]) + 20*(xcovtest[,3]-0.5)^2+10*xcovtest[,4]+
  5*xcovtest[,5]+epsilontest

#Train the object 
bart_bma_example <- bartBMA(x.train = xcov,y.train=y,x.test=xcovtest,zero_split = 1, 
                            only_max_num_trees = 1,split_rule_node = 0)
#Obtain the variable importances
varIncProb(bart_bma_example)
}
