% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pois_gamma.R
\name{sim_pred_gamma_pois}
\alias{sim_pred_gamma_pois}
\title{Simulate from a gamma-Poisson posterior predictive distribution}
\usage{
sim_pred_gamma_pois(theta_sim_vals, data, nrep)
}
\arguments{
\item{theta_sim_vals}{A numeric matrix with \code{nrow(data)} columns.
Each row of \code{theta_sim_vals} contains binomial success probabilities
simulated from their posterior distribution.}

\item{data}{A 2-column numeric matrix: the numbers of successes in column 1
and the corresponding numbers of trials in column 2.}

\item{nrep}{A numeric scalar.  The number of replications of the original
dataset simulated from the posterior predictive distribution.
If \code{nrep} is greater than \code{nrow(theta_sim_vals)} then
\code{nrep} is set equal to \code{nrow(theta_sim_vals)}.}
}
\value{
A numeric matrix with \code{nrep} columns.  Each column contains
  a draw from the posterior predictive distribution of the number of
  successes.
}
\description{
Simulates \code{nrep} draws from the posterior predictive distribution
of the beta-binomial model described in \code{\link{hef}}.
This function is called within \code{\link{hef}} when the argument
\code{nrep} is supplied.
}
\examples{
pump_res <- hef(model = "gamma_pois", data = pump)
pump_sim_pred <- sim_pred_gamma_pois(pump_res$theta_sim_vals, pump, 50)
}
