% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_print.R
\name{summary.hef}
\alias{summary.hef}
\title{Summarizing hef objects}
\usage{
\method{summary}{hef}(object, ..., params = c("hyper", "pop"),
  which_pop = 1:ncol(object$theta_sim_vals))
}
\arguments{
\item{object}{an object of class "hef", a result of a call to
\code{\link{hef}}.}

\item{...}{Additional arguments passed on to \code{\link[rust]{summary.ru}}.}

\item{params}{A character scalar.

  If \code{params = "hyper"} then the posterior samples of all
  hyperparameter values in \eqn{\phi} are summarized using
  \code{\link[rust]{summary.ru}}.

  If \code{params = "pop"} then only posterior samples of the populations
  specified in \code{which_pop} are summarized.}

\item{which_pop}{An integer vector.  If \code{params = "pop"} then
\code{which_pop} indicates which populations, i.e. which columns
of \code{object$theta_sim_vals} to summarize, using
\code{\link{summary}}.  The default is all populations.}
}
\description{
\code{summary} method for class "hef".
}
\examples{
# Beta-binomial model, rat data
rat_res <- hef(model = "beta_binom", data = rat)

# Posterior summaries of the hyperparameters alpha and beta
summary(rat_res)

# Posterior summaries of the binomial probability for rats 1 to 3
summary(rat_res, params = "pop", which_pop = 1:3)
}
