% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects_apc.R
\name{effects.apc}
\alias{effects.apc}
\title{Effects from Fitted APC Model}
\usage{
\method{effects}{apc}(object, mean = FALSE, quantiles = 0.5,
  update = FALSE, ...)
}
\arguments{
\item{object}{an apc object}

\item{mean}{logical. If TRUE, mean effects are computed}

\item{quantiles}{Scalar or vector of quantiles to compute (only if mean=FALSE)}

\item{update}{logical. If TRUE, the apc object including the effects is returned}

\item{...}{Additional arguments will be ignored}
}
\value{
List of age, period, cohort effects or apc object including effects (if update=TRUE)
}
\description{
Effects from Fitted APC Model
}
\examples{
\dontrun{
data(apc)
model <- bamp(cases, population, age="rw1", period="rw1", cohort="rw1", periods_per_agegroup = 5)
effects(model)
}
}
