% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdm_sim.R
\name{sdm_sim}
\alias{sdm_sim}
\title{sdm_sim: Simulate single species dispersal dynamics using the BAM framework.}
\usage{
sdm_sim(
  set_A,
  set_M,
  initial_points,
  nsteps,
  stochastic_dispersal = TRUE,
  disp_prop2_suitability = TRUE,
  disper_prop = 0.5,
  progress_bar = TRUE
)
}
\arguments{
\item{set_A}{A setA object returned by the function
\code{\link[bamm]{model2sparse}}}

\item{set_M}{A setM object containing the adjacency matrix of the
study area.
See \code{\link[bamm]{adj_mat}}}

\item{initial_points}{A sparse vector returned by the function
\code{\link[bamm]{occs2sparse}}}

\item{nsteps}{Number of steps to run the simulation}

\item{stochastic_dispersal}{Logical. If dispersal depends on a probability of
visiting neighbor cells (Moore neighborhood).}

\item{disp_prop2_suitability}{Logical. If probability of dispersal
is proportional to the suitability of reachable cells. The proportional
value must be declared in the parameter `disper_prop`.}

\item{disper_prop}{Probability of dispersal to reachable cells.}

\item{progress_bar}{Show progress bar}
}
\value{
An object of class \code{\link[bamm]{bam}} with simulation results.
The simulation are stored in the sdm_sim slot (a list of sparse matrices).
}
\description{
sdm_sim: Simulate single species dispersal dynamics using the BAM framework.
}
\details{
The model is cellular automata where the occupied area
of a species at time \eqn{t+1} is estimated by the multiplication of two
binary matrices: one matrix represents movements (M), another
abiotic -niche- tolerances (A)
(Soberon and Osorio-Olvera, 2022).
\deqn{\mathbf{G}_j(t+1) =\mathbf{A}_j(t)\mathbf{M}_j
\mathbf{G}_j(t)}
The equation describes a very simple process: To find the occupied patches
in \eqn{t+1} start with those occupied at time \eqn{t} denoted by
\eqn{\mathbf{G}_j(t)}, allow the individuals to disperse among
adjacent patches, as defined by \eqn{\mathbf{M}_j}, then remove individuals
from patches that are unsuitable, as defined by \eqn{\mathbf{A}_j(t)}.
}
\examples{
\donttest{
model_path <- system.file("extdata/Lepus_californicus_cont.tif",
                          package = "bamm")
model <- raster::raster(model_path)

sparse_mod <- bamm::model2sparse(model,threshold=0.05)
adj_mod <- bamm::adj_mat(sparse_mod,ngbs=1)
occs_lep_cal <- data.frame(longitude = c(-110.08880,
                                         -98.89638),
                           latitude = c(30.43455,
                                        25.19919))

occs_sparse <- bamm::occs2sparse(modelsparse = sparse_mod,
                                occs = occs_lep_cal)
sdm_lep_cal <- bamm::sdm_sim(set_A = sparse_mod,
                             set_M = adj_mod,
                             initial_points = occs_sparse,
                             nsteps = 10,
                             stochastic_dispersal = TRUE,
                             disp_prop2_suitability=TRUE,
                             disper_prop=0.5,
                             progress_bar=TRUE)

sim_res <- bamm::sim2Raster(sdm_lep_cal)
raster::plot(sim_res)

}
}
\references{
\insertRef{SoberonOsorio}{bamm}.
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
