% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_matrices.R
\name{create_matrices}
\alias{create_matrices}
\title{Create (in)equality constraint matrices}
\usage{
create_matrices(varnames, hyp)
}
\arguments{
\item{varnames}{A character (vector of characters), containing names of
variables used in the hypotheses.  %Object of class \code{\link{lm}}, from
which the model parameters are extracted.}

\item{hyp}{A character string, containing a hypothesis (see Details).}
}
\value{
A pair of named matrices for every hypothesis specified in the
\code{hyp} argument; one matrix named ERr, specifying equality constraints,
and one matrix named IRr, specifying inequality constraints.
}
\description{
Parses a character string describing a set of informative hypotheses,
and returns (in)equality constraint matrices
}
\details{
Informative hypotheses specified as a character string by "hyp" should
adhere to the following simple syntax: \itemize{ \item Competing hypotheses
are separated by ";".  Thus, "a=b;a>b" means that H1: a=b, and H2: a>b.
\item Each individual hypothesis consists of a (series of) (in)equality
constraint(s). Every single (in)equality constraint is of the form "R1*mu1 +
R2*mu2+... = r", where capital Rs refer to numeric scaling constants, must
refer to the names of parameters in the model, and the lower case r refers
to a constant. Standard mathematical simplification rules apply; thus,
"R1*mu1 = R2*mu2" is equivalent to "R1*mu1 - R2*mu2 = 0".  \item Multiple
unrelated constraints within one hypothesis can be chained by "&". Thus,
"a=b&c=d" means that H1: a=b AND c=d.  \item Multiple related constraints
within one hypothesis can be chained by repeating the (in)equality operators
"=", "<", or ">". Thus, "a<b<c" means that H1: a < b AND b < c.  \item
Parameters can be grouped by placing them in a parenthesized, comma
separated list. Thus, "(a,b)>c" means that H1: a > c AND b > c.  Similarly,
"(a,b)>(c,d)" means that H1: a > c AND b > c AND b > c AND b > d.  }
}
\author{
Caspar van Lissa
}
\keyword{internal}
\keyword{utilities}
