% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_imp.R
\name{var_imp.bagger}
\alias{var_imp.bagger}
\title{Obtain variable importance scores}
\usage{
\method{var_imp}{bagger}(object, ...)
}
\arguments{
\item{object}{An object.}

\item{...}{Not currently used.}
}
\value{
A tibble with columns for \code{term} (the predictor), \code{value} (the
mean importance score), \code{std.error} (the standard error), and \code{used} (the
occurrences of the predictors).
}
\description{
Obtain variable importance scores
}
\details{
\code{baguette} can compute different variable importance scores for
each model in the ensemble. The \code{var_imp()} function returns the average
importance score for each model. Additionally, the function returns the
number of times that each predictor is included in the final prediction
equation.

Specific methods used by the models are:

\emph{CART}: The model accumulates the improvement of the model that occurs when
a predictor is used in a split. These values are taken form the \code{rpart}
object. See \code{rpart::rpart.object()}.

\emph{MARS}: MARS models include a backwards elimination feature selection
routine that looks at reductions in the generalized cross-validation (GCV)
estimate of error. The \code{earth()} function tracks the changes in model
statistics, such as the GCV, for each predictor and accumulates the
reduction in the statistic when each predictor's feature is added to the
model. This total reduction is used as the variable importance measure. If a
predictor was never used in any of the MARS basis functions in the final
model (after pruning), it has an importance value of zero. \code{baguette} wraps
\code{earth::evimp()}.

\emph{C5.0}: \code{C5.0} measures predictor importance by determining the percentage
of training set samples that fall into all the terminal nodes after the
split. For example, the predictor in the first split automatically has an
importance measurement of 100 percent since all samples are affected by this
split. Other predictors may be used frequently in splits, but if the
terminal nodes cover only a handful of training set samples, the importance
scores may be close to zero.

Note that the \code{value} column that is the average of the importance scores
form each model. The divisor of this average (and the corresponding standard
error) is the number of models (as opposed to the number of models that
used the predictor). This means that the importance scores for a predictor
that was not used in the model has an implicit zero importance.
}
