// Generated by rstantools.  Do not edit by hand.

/*
    baggr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    baggr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with baggr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_rubin_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_rubin");
    reader.add_event(1, 1, "include", "/functions/prior_increment.stan");
    reader.add_event(1, 0, "start", "/functions/prior_increment.stan");
    reader.add_event(32, 31, "end", "/functions/prior_increment.stan");
    reader.add_event(32, 2, "restart", "model_rubin");
    reader.add_event(143, 111, "end", "model_rubin");
    return reader;
}
template <typename T1__, typename T2__>
typename boost::math::tools::promote_args<T1__, T2__>::type
prior_increment_real(const int& family,
                         const T1__& y,
                         const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& pars, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 3;
        local_scalar_t__ inc(DUMMY_VAR__);
        (void) inc;  // dummy to suppress unused var warning
        stan::math::initialize(inc, DUMMY_VAR__);
        stan::math::fill(inc, DUMMY_VAR__);
        current_statement_begin__ = 4;
        if (as_bool(logical_eq(family, 0))) {
            current_statement_begin__ = 5;
            stan::math::assign(inc, uniform_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 6;
        if (as_bool(logical_eq(family, 1))) {
            current_statement_begin__ = 7;
            stan::math::assign(inc, normal_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 8;
        if (as_bool(logical_eq(family, 2))) {
            current_statement_begin__ = 9;
            stan::math::assign(inc, cauchy_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 12;
        if (as_bool(logical_eq(family, 5))) {
            current_statement_begin__ = 13;
            stan::math::assign(inc, lognormal_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 14;
        if (as_bool(logical_eq(family, 6))) {
            current_statement_begin__ = 15;
            stan::math::assign(inc, student_t_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1), get_base1(pars, 3, "pars", 1)));
        }
        current_statement_begin__ = 16;
        return stan::math::promote_scalar<fun_return_scalar_t__>(inc);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct prior_increment_real_functor__ {
    template <typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T1__, T2__>::type
    operator()(const int& family,
                         const T1__& y,
                         const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& pars, std::ostream* pstream__) const {
        return prior_increment_real(family, y, pars, pstream__);
    }
};
template <typename T1__, typename T2__>
typename boost::math::tools::promote_args<T1__, T2__>::type
prior_increment_vec(const int& family,
                        const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& pars, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 20;
        local_scalar_t__ inc(DUMMY_VAR__);
        (void) inc;  // dummy to suppress unused var warning
        stan::math::initialize(inc, DUMMY_VAR__);
        stan::math::fill(inc, DUMMY_VAR__);
        current_statement_begin__ = 21;
        if (as_bool(logical_eq(family, 0))) {
            current_statement_begin__ = 22;
            stan::math::assign(inc, uniform_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 23;
        if (as_bool(logical_eq(family, 1))) {
            current_statement_begin__ = 24;
            stan::math::assign(inc, normal_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 25;
        if (as_bool(logical_eq(family, 2))) {
            current_statement_begin__ = 26;
            stan::math::assign(inc, cauchy_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 27;
        if (as_bool(logical_eq(family, 5))) {
            current_statement_begin__ = 28;
            stan::math::assign(inc, lognormal_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 29;
        if (as_bool(logical_eq(family, 6))) {
            current_statement_begin__ = 30;
            stan::math::assign(inc, student_t_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1), get_base1(pars, 3, "pars", 1)));
        }
        current_statement_begin__ = 31;
        return stan::math::promote_scalar<fun_return_scalar_t__>(inc);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct prior_increment_vec_functor__ {
    template <typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T1__, T2__>::type
    operator()(const int& family,
                        const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& pars, std::ostream* pstream__) const {
        return prior_increment_vec(family, y, pars, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_rubin
  : public stan::model::model_base_crtp<model_rubin> {
private:
        int pooling_type;
        int K;
        vector_d theta_hat_k;
        vector_d se_theta_k;
        int Nc;
        matrix_d X;
        int prior_hypermean_fam;
        int prior_hypersd_fam;
        int prior_beta_fam;
        vector_d prior_hypermean_val;
        vector_d prior_hypersd_val;
        vector_d prior_beta_val;
        int K_test;
        vector_d test_theta_hat_k;
        vector_d test_se_theta_k;
        matrix_d X_test;
        int K_pooled;
public:
    model_rubin(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_rubin(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_rubin_namespace::model_rubin";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 37;
            context__.validate_dims("data initialization", "pooling_type", "int", context__.to_vec());
            pooling_type = int(0);
            vals_i__ = context__.vals_i("pooling_type");
            pos__ = 0;
            pooling_type = vals_i__[pos__++];
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 0);
            current_statement_begin__ = 41;
            validate_non_negative_index("theta_hat_k", "K", K);
            context__.validate_dims("data initialization", "theta_hat_k", "vector_d", context__.to_vec(K));
            theta_hat_k = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("theta_hat_k");
            pos__ = 0;
            size_t theta_hat_k_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < theta_hat_k_j_1_max__; ++j_1__) {
                theta_hat_k(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 42;
            validate_non_negative_index("se_theta_k", "K", K);
            context__.validate_dims("data initialization", "se_theta_k", "vector_d", context__.to_vec(K));
            se_theta_k = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("se_theta_k");
            pos__ = 0;
            size_t se_theta_k_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < se_theta_k_j_1_max__; ++j_1__) {
                se_theta_k(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "se_theta_k", se_theta_k, 0);
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "Nc", "int", context__.to_vec());
            Nc = int(0);
            vals_i__ = context__.vals_i("Nc");
            pos__ = 0;
            Nc = vals_i__[pos__++];
            check_greater_or_equal(function__, "Nc", Nc, 0);
            current_statement_begin__ = 44;
            validate_non_negative_index("X", "K", K);
            validate_non_negative_index("X", "Nc", Nc);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(K,Nc));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(K, Nc);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = Nc;
            size_t X_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 47;
            context__.validate_dims("data initialization", "prior_hypermean_fam", "int", context__.to_vec());
            prior_hypermean_fam = int(0);
            vals_i__ = context__.vals_i("prior_hypermean_fam");
            pos__ = 0;
            prior_hypermean_fam = vals_i__[pos__++];
            current_statement_begin__ = 48;
            context__.validate_dims("data initialization", "prior_hypersd_fam", "int", context__.to_vec());
            prior_hypersd_fam = int(0);
            vals_i__ = context__.vals_i("prior_hypersd_fam");
            pos__ = 0;
            prior_hypersd_fam = vals_i__[pos__++];
            current_statement_begin__ = 49;
            context__.validate_dims("data initialization", "prior_beta_fam", "int", context__.to_vec());
            prior_beta_fam = int(0);
            vals_i__ = context__.vals_i("prior_beta_fam");
            pos__ = 0;
            prior_beta_fam = vals_i__[pos__++];
            current_statement_begin__ = 50;
            validate_non_negative_index("prior_hypermean_val", "3", 3);
            context__.validate_dims("data initialization", "prior_hypermean_val", "vector_d", context__.to_vec(3));
            prior_hypermean_val = Eigen::Matrix<double, Eigen::Dynamic, 1>(3);
            vals_r__ = context__.vals_r("prior_hypermean_val");
            pos__ = 0;
            size_t prior_hypermean_val_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < prior_hypermean_val_j_1_max__; ++j_1__) {
                prior_hypermean_val(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 51;
            validate_non_negative_index("prior_hypersd_val", "3", 3);
            context__.validate_dims("data initialization", "prior_hypersd_val", "vector_d", context__.to_vec(3));
            prior_hypersd_val = Eigen::Matrix<double, Eigen::Dynamic, 1>(3);
            vals_r__ = context__.vals_r("prior_hypersd_val");
            pos__ = 0;
            size_t prior_hypersd_val_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < prior_hypersd_val_j_1_max__; ++j_1__) {
                prior_hypersd_val(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 52;
            validate_non_negative_index("prior_beta_val", "3", 3);
            context__.validate_dims("data initialization", "prior_beta_val", "vector_d", context__.to_vec(3));
            prior_beta_val = Eigen::Matrix<double, Eigen::Dynamic, 1>(3);
            vals_r__ = context__.vals_r("prior_beta_val");
            pos__ = 0;
            size_t prior_beta_val_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < prior_beta_val_j_1_max__; ++j_1__) {
                prior_beta_val(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 55;
            context__.validate_dims("data initialization", "K_test", "int", context__.to_vec());
            K_test = int(0);
            vals_i__ = context__.vals_i("K_test");
            pos__ = 0;
            K_test = vals_i__[pos__++];
            check_greater_or_equal(function__, "K_test", K_test, 0);
            current_statement_begin__ = 56;
            validate_non_negative_index("test_theta_hat_k", "K_test", K_test);
            context__.validate_dims("data initialization", "test_theta_hat_k", "vector_d", context__.to_vec(K_test));
            test_theta_hat_k = Eigen::Matrix<double, Eigen::Dynamic, 1>(K_test);
            vals_r__ = context__.vals_r("test_theta_hat_k");
            pos__ = 0;
            size_t test_theta_hat_k_j_1_max__ = K_test;
            for (size_t j_1__ = 0; j_1__ < test_theta_hat_k_j_1_max__; ++j_1__) {
                test_theta_hat_k(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 57;
            validate_non_negative_index("test_se_theta_k", "K_test", K_test);
            context__.validate_dims("data initialization", "test_se_theta_k", "vector_d", context__.to_vec(K_test));
            test_se_theta_k = Eigen::Matrix<double, Eigen::Dynamic, 1>(K_test);
            vals_r__ = context__.vals_r("test_se_theta_k");
            pos__ = 0;
            size_t test_se_theta_k_j_1_max__ = K_test;
            for (size_t j_1__ = 0; j_1__ < test_se_theta_k_j_1_max__; ++j_1__) {
                test_se_theta_k(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "test_se_theta_k", test_se_theta_k, 0);
            current_statement_begin__ = 58;
            validate_non_negative_index("X_test", "K_test", K_test);
            validate_non_negative_index("X_test", "Nc", Nc);
            context__.validate_dims("data initialization", "X_test", "matrix_d", context__.to_vec(K_test,Nc));
            X_test = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(K_test, Nc);
            vals_r__ = context__.vals_r("X_test");
            pos__ = 0;
            size_t X_test_j_2_max__ = Nc;
            size_t X_test_j_1_max__ = K_test;
            for (size_t j_2__ = 0; j_2__ < X_test_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_test_j_1_max__; ++j_1__) {
                    X_test(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            // initialize transformed data variables
            current_statement_begin__ = 62;
            K_pooled = int(0);
            stan::math::fill(K_pooled, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 63;
            if (as_bool(logical_eq(pooling_type, 2))) {
                current_statement_begin__ = 64;
                stan::math::assign(K_pooled, 0);
            }
            current_statement_begin__ = 65;
            if (as_bool(logical_neq(pooling_type, 2))) {
                current_statement_begin__ = 66;
                stan::math::assign(K_pooled, K);
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 70;
            validate_non_negative_index("mu", "(logical_neq(pooling_type, 0) ? 1 : 0 )", (logical_neq(pooling_type, 0) ? 1 : 0 ));
            num_params_r__ += (1 * (logical_neq(pooling_type, 0) ? 1 : 0 ));
            current_statement_begin__ = 71;
            validate_non_negative_index("tau", "(logical_eq(pooling_type, 1) ? 1 : 0 )", (logical_eq(pooling_type, 1) ? 1 : 0 ));
            num_params_r__ += (1 * (logical_eq(pooling_type, 1) ? 1 : 0 ));
            current_statement_begin__ = 72;
            validate_non_negative_index("eta", "K_pooled", K_pooled);
            num_params_r__ += K_pooled;
            current_statement_begin__ = 73;
            validate_non_negative_index("beta", "Nc", Nc);
            num_params_r__ += Nc;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_rubin() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 70;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        validate_non_negative_index("mu", "(logical_neq(pooling_type, 0) ? 1 : 0 )", (logical_neq(pooling_type, 0) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "mu", "double", context__.to_vec((logical_neq(pooling_type, 0) ? 1 : 0 )));
        std::vector<double> mu((logical_neq(pooling_type, 0) ? 1 : 0 ), double(0));
        size_t mu_k_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
            mu[k_0__] = vals_r__[pos__++];
        }
        size_t mu_i_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < mu_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(mu[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 71;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        validate_non_negative_index("tau", "(logical_eq(pooling_type, 1) ? 1 : 0 )", (logical_eq(pooling_type, 1) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "tau", "double", context__.to_vec((logical_eq(pooling_type, 1) ? 1 : 0 )));
        std::vector<double> tau((logical_eq(pooling_type, 1) ? 1 : 0 ), double(0));
        size_t tau_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            tau[k_0__] = vals_r__[pos__++];
        }
        size_t tau_i_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < tau_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, tau[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 72;
        if (!(context__.contains_r("eta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta");
        pos__ = 0U;
        validate_non_negative_index("eta", "K_pooled", K_pooled);
        context__.validate_dims("parameter initialization", "eta", "vector_d", context__.to_vec(K_pooled));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta(K_pooled);
        size_t eta_j_1_max__ = K_pooled;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            eta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(eta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 73;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "Nc", Nc);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(Nc));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(Nc);
        size_t beta_j_1_max__ = Nc;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 70;
            std::vector<local_scalar_t__> mu;
            size_t mu_d_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
            mu.reserve(mu_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < mu_d_0_max__; ++d_0__) {
                if (jacobian__)
                    mu.push_back(in__.scalar_constrain(lp__));
                else
                    mu.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 71;
            std::vector<local_scalar_t__> tau;
            size_t tau_d_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
            tau.reserve(tau_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < tau_d_0_max__; ++d_0__) {
                if (jacobian__)
                    tau.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    tau.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 72;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta;
            (void) eta;  // dummy to suppress unused var warning
            if (jacobian__)
                eta = in__.vector_constrain(K_pooled, lp__);
            else
                eta = in__.vector_constrain(K_pooled);
            current_statement_begin__ = 73;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(Nc, lp__);
            else
                beta = in__.vector_constrain(Nc);
            // transformed parameters
            current_statement_begin__ = 76;
            validate_non_negative_index("theta_k", "K_pooled", K_pooled);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_k(K_pooled);
            stan::math::initialize(theta_k, DUMMY_VAR__);
            stan::math::fill(theta_k, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 77;
            for (int k = 1; k <= K_pooled; ++k) {
                current_statement_begin__ = 78;
                if (as_bool(logical_eq(pooling_type, 0))) {
                    current_statement_begin__ = 82;
                    stan::model::assign(theta_k, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                get_base1(eta, k, "eta", 1), 
                                "assigning variable theta_k");
                }
                current_statement_begin__ = 83;
                if (as_bool(logical_eq(pooling_type, 1))) {
                    current_statement_begin__ = 84;
                    stan::model::assign(theta_k, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                (get_base1(mu, 1, "mu", 1) + (get_base1(eta, k, "eta", 1) * get_base1(tau, 1, "tau", 1))), 
                                "assigning variable theta_k");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 76;
            size_t theta_k_j_1_max__ = K_pooled;
            for (size_t j_1__ = 0; j_1__ < theta_k_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta_k(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta_k" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta_k: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            {
            current_statement_begin__ = 88;
            validate_non_negative_index("fe_k", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> fe_k(K);
            stan::math::initialize(fe_k, DUMMY_VAR__);
            stan::math::fill(fe_k, DUMMY_VAR__);
            current_statement_begin__ = 89;
            if (as_bool(logical_gt(K, 0))) {
                current_statement_begin__ = 90;
                if (as_bool(logical_eq(Nc, 0))) {
                    current_statement_begin__ = 91;
                    stan::math::assign(fe_k, rep_vector(0.0, K));
                } else {
                    current_statement_begin__ = 93;
                    stan::math::assign(fe_k, multiply(X, beta));
                }
            }
            current_statement_begin__ = 97;
            if (as_bool(logical_gt(pooling_type, 0))) {
                current_statement_begin__ = 98;
                lp_accum__.add(prior_increment_real(prior_hypermean_fam, get_base1(mu, 1, "mu", 1), prior_hypermean_val, pstream__));
            } else {
                current_statement_begin__ = 100;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 102;
                    lp_accum__.add(prior_increment_real(prior_hypermean_fam, get_base1(eta, k, "eta", 1), prior_hypermean_val, pstream__));
                }
            }
            current_statement_begin__ = 106;
            if (as_bool(logical_eq(pooling_type, 1))) {
                current_statement_begin__ = 107;
                lp_accum__.add(prior_increment_real(prior_hypersd_fam, get_base1(tau, 1, "tau", 1), prior_hypersd_val, pstream__));
            }
            current_statement_begin__ = 111;
            if (as_bool(logical_gt(Nc, 0))) {
                current_statement_begin__ = 112;
                lp_accum__.add(prior_increment_vec(prior_beta_fam, beta, prior_beta_val, pstream__));
            }
            current_statement_begin__ = 115;
            if (as_bool(logical_gt(K, 0))) {
                current_statement_begin__ = 116;
                if (as_bool(logical_eq(pooling_type, 1))) {
                    current_statement_begin__ = 117;
                    lp_accum__.add(normal_log<propto__>(eta, 0, 1));
                }
                current_statement_begin__ = 118;
                if (as_bool(logical_neq(pooling_type, 2))) {
                    current_statement_begin__ = 119;
                    lp_accum__.add(normal_log<propto__>(theta_hat_k, add(theta_k, fe_k), se_theta_k));
                }
                current_statement_begin__ = 120;
                if (as_bool(logical_eq(pooling_type, 2))) {
                    current_statement_begin__ = 121;
                    lp_accum__.add(normal_log<propto__>(theta_hat_k, add(rep_vector(get_base1(mu, 1, "mu", 1), K), fe_k), se_theta_k));
                }
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu");
        names__.push_back("tau");
        names__.push_back("eta");
        names__.push_back("beta");
        names__.push_back("theta_k");
        names__.push_back("logpd");
        names__.push_back("fe_k_test");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((logical_neq(pooling_type, 0) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(pooling_type, 1) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K_pooled);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Nc);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K_pooled);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(K_test, 0) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K_test);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_rubin_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> mu;
        size_t mu_d_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        mu.reserve(mu_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < mu_d_0_max__; ++d_0__) {
            mu.push_back(in__.scalar_constrain());
        }
        size_t mu_k_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }
        std::vector<double> tau;
        size_t tau_d_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        tau.reserve(tau_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < tau_d_0_max__; ++d_0__) {
            tau.push_back(in__.scalar_lb_constrain(0));
        }
        size_t tau_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta = in__.vector_constrain(K_pooled);
        size_t eta_j_1_max__ = K_pooled;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            vars__.push_back(eta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(Nc);
        size_t beta_j_1_max__ = Nc;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 76;
            validate_non_negative_index("theta_k", "K_pooled", K_pooled);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_k(K_pooled);
            stan::math::initialize(theta_k, DUMMY_VAR__);
            stan::math::fill(theta_k, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 77;
            for (int k = 1; k <= K_pooled; ++k) {
                current_statement_begin__ = 78;
                if (as_bool(logical_eq(pooling_type, 0))) {
                    current_statement_begin__ = 82;
                    stan::model::assign(theta_k, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                get_base1(eta, k, "eta", 1), 
                                "assigning variable theta_k");
                }
                current_statement_begin__ = 83;
                if (as_bool(logical_eq(pooling_type, 1))) {
                    current_statement_begin__ = 84;
                    stan::model::assign(theta_k, 
                                stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                (get_base1(mu, 1, "mu", 1) + (get_base1(eta, k, "eta", 1) * get_base1(tau, 1, "tau", 1))), 
                                "assigning variable theta_k");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t theta_k_j_1_max__ = K_pooled;
                for (size_t j_1__ = 0; j_1__ < theta_k_j_1_max__; ++j_1__) {
                    vars__.push_back(theta_k(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 126;
            validate_non_negative_index("logpd", "(logical_gt(K_test, 0) ? 1 : 0 )", (logical_gt(K_test, 0) ? 1 : 0 ));
            std::vector<double> logpd((logical_gt(K_test, 0) ? 1 : 0 ), double(0));
            stan::math::initialize(logpd, DUMMY_VAR__);
            stan::math::fill(logpd, DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("fe_k_test", "K_test", K_test);
            Eigen::Matrix<double, Eigen::Dynamic, 1> fe_k_test(K_test);
            stan::math::initialize(fe_k_test, DUMMY_VAR__);
            stan::math::fill(fe_k_test, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 128;
            if (as_bool(logical_gt(K_test, 0))) {
                current_statement_begin__ = 129;
                if (as_bool(logical_eq(Nc, 0))) {
                    current_statement_begin__ = 130;
                    stan::math::assign(fe_k_test, rep_vector(0.0, K_test));
                } else {
                    current_statement_begin__ = 132;
                    stan::math::assign(fe_k_test, multiply(X_test, beta));
                }
                current_statement_begin__ = 133;
                stan::model::assign(logpd, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable logpd");
                current_statement_begin__ = 134;
                for (int k = 1; k <= K_test; ++k) {
                    current_statement_begin__ = 135;
                    if (as_bool(logical_eq(pooling_type, 1))) {
                        current_statement_begin__ = 136;
                        stan::model::assign(logpd, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(logpd, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "logpd") + normal_log(get_base1(test_theta_hat_k, k, "test_theta_hat_k", 1), add(get_base1(mu, 1, "mu", 1), fe_k_test), stan::math::sqrt((pow(get_base1(tau, 1, "tau", 1), 2) + pow(get_base1(test_se_theta_k, k, "test_se_theta_k", 1), 2))))), 
                                    "assigning variable logpd");
                    }
                    current_statement_begin__ = 137;
                    if (as_bool(logical_eq(pooling_type, 2))) {
                        current_statement_begin__ = 138;
                        stan::model::assign(logpd, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(logpd, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "logpd") + normal_log(get_base1(test_theta_hat_k, k, "test_theta_hat_k", 1), add(get_base1(mu, 1, "mu", 1), fe_k_test), stan::math::sqrt(pow(get_base1(test_se_theta_k, k, "test_se_theta_k", 1), 2)))), 
                                    "assigning variable logpd");
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 126;
            size_t logpd_k_0_max__ = (logical_gt(K_test, 0) ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < logpd_k_0_max__; ++k_0__) {
                vars__.push_back(logpd[k_0__]);
            }
            current_statement_begin__ = 127;
            size_t fe_k_test_j_1_max__ = K_test;
            for (size_t j_1__ = 0; j_1__ < fe_k_test_j_1_max__; ++j_1__) {
                vars__.push_back(fe_k_test(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_rubin";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t mu_k_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_j_1_max__ = K_pooled;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = Nc;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_k_j_1_max__ = K_pooled;
            for (size_t j_1__ = 0; j_1__ < theta_k_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_k" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t logpd_k_0_max__ = (logical_gt(K_test, 0) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < logpd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logpd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fe_k_test_j_1_max__ = K_test;
        for (size_t j_1__ = 0; j_1__ < fe_k_test_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fe_k_test" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t mu_k_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_j_1_max__ = K_pooled;
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = Nc;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_k_j_1_max__ = K_pooled;
            for (size_t j_1__ = 0; j_1__ < theta_k_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_k" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t logpd_k_0_max__ = (logical_gt(K_test, 0) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < logpd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logpd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fe_k_test_j_1_max__ = K_test;
        for (size_t j_1__ = 0; j_1__ < fe_k_test_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fe_k_test" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_rubin_namespace::model_rubin stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
