% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsss_dens.R
\name{hsss_dens}
\alias{hsss_dens}
\title{Generalized bagging CV bandwidth selector for Parzen-Rosenblatt estimator}
\usage{
hsss_dens(x, r, s, nb = r, h0, h1, ncores = parallel::detectCores())
}
\arguments{
\item{x}{Vector. Sample.}

\item{r}{Positive integer. Size of the subsamples.}

\item{s}{Positive integer. Number of subsamples.}

\item{nb}{Positive integer. Number of bins.}

\item{h0}{Positive real number. Range over which to minimize, left bound.}

\item{h1}{Positive real number. Range over which to minimize, right bound.}

\item{ncores}{Positive integer. Number of cores with which to parallelize the computations.}
}
\value{
Bagged CV bandwidth.
}
\description{
Generalized bagging CV bandwidth selector for Parzen-Rosenblatt estimator
}
\details{
Generalized bagging cross-validation bandwidth selector for the Parzen-Rosenblatt estimator.
}
\examples{
set.seed(1)
x <- rnorm(10^5)
hsss_dens(x, 5000, 100, 1000, 0.001, 1, 2)

}
