% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_prior}
\alias{set_prior}
\title{Specify Prior for Model Term}
\usage{
set_prior(mod, formula)
}
\arguments{
\item{mod}{A \code{bage_mod} object, created with
\code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{formula}{A formula giving the term
and a function for creating a prior.}
}
\value{
A modified \code{bage_mod} object.
}
\description{
Specify a prior distribution for an intercept,
a main effect, or an interaction.
}
\details{
If \code{set_prior()} is applied to
a fitted model, it 'unfits'
the model, deleting existing estimates.
}
\examples{
mod <- mod_pois(injuries ~ age + year,
                data = injuries,
                exposure = popn)
mod
mod |> set_prior(age ~ RW2())
}
\seealso{
\itemize{
\item \link{priors} Current choices for prior distributions
\item \code{\link[=is_fitted]{is_fitted()}} Test whether a model is fitted
\item \code{\link[=set_disp]{set_disp()}} Specify prior for dispersion
}
}
