% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2DownloadFileById.R
\name{b2DownloadFileById}
\alias{b2DownloadFileById}
\title{Download B2 File by ID.}
\usage{
b2DownloadFileById(fileId, overwrite = FALSE)
}
\arguments{
\item{fileId}{The unique identifier of the file to be downloaded. File IDs
may be obtained through the \code{b2ListFiles}, \code{b2ListFileVersions}
and \code{b2UploadFile} functions in this package.}

\item{overwrite}{Binary TRUE or FALSE decision to overwrite any files in the
current working directory, whose names match the downloaded file name.}
}
\value{
If successful the response headers include the Content-Type that was
  specified when the file was uploaded. They also include the X-Bz-FileName
  and X-Bz-Content-Sha1 headers. The X-Bz-FileName uses percent-encoding, as
  if it were a URL parameter. If successful, the file will be downloaded to
  the current working directory.
}
\description{
\code{b2DownloadFileById} downloads a file from the user's account on the
Backblaze B2 cloud storage product.
}
\details{
This function downloads a file from the user's account on the Backblaze B2
cloud storage product using the file's unique ID only. Files of the same name
may have multiple versions stored on B2. Therefore, every file version will
have a unique ID, which can be used for downloading that specific version.
Further details regarding this API call are available here:

\url{https://www.backblaze.com/b2/docs/b2_download_file_by_id.html}

\code{fileId} is mandatory and must be user defined. \code{overwrite} is
optionally user defined and defaults to FALSE.
}
\examples{
\dontrun{
b2DownloadFileById(fileId = "Unique_identifier_of_the_file_to_download",
overwrite = TRUE)
}

}

