% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPostprocessedEnvs.R
\name{plotPostprocessedEnvs}
\alias{plotPostprocessedEnvs}
\title{plotPostprocessedEnvs}
\usage{
plotPostprocessedEnvs(results)
}
\arguments{
\item{results}{Results from \code{\link{postprocessEnvs}}.}
}
\value{
This function returns a \code{ggplot} object.
}
\description{
Plot output from \code{\link{postprocessEnvs}}.
}
\examples{
set.seed(123)
# 1. Generate simulation data based on number of infected persons per day:
x <- dataCovidBeds20200624
StartDate <- x$Day[1]
EndDate <- x$Day[length(x$Day)]
arrivalTimes <- getArrivalTimes(x$Infected)
para <- babsimHospitalPara()
conf <- babsimToolsConf()
y <- babsimHospital(
  arrivalTimes = arrivalTimes,
  conf = conf,
  para = para
)

# 2. Postprocess simmer environment:
res <- postprocessEnvs(envs = y, StartDate = "2020-03-03")
# 4. Plot results
p <- plotPostprocessedEnvs(res)
# print(p)
}
