% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http.R
\name{iamHTTP}
\alias{iamHTTP}
\alias{stsHTTP}
\title{Workhorse API Query Functions}
\usage{
iamHTTP(query, verb = "GET", body = "", version = "2010-05-08",
  region = Sys.getenv("AWS_DEFAULT_REGION", "us-east-1"), key = NULL,
  secret = NULL, session_token = NULL, ...)

stsHTTP(query, version = "2011-06-15",
  region = Sys.getenv("AWS_DEFAULT_REGION", "us-east-1"), key = NULL,
  secret = NULL, session_token = NULL, ...)
}
\arguments{
\item{query}{A named list specifying query arguments.}

\item{verb}{A character string specifying an HTTP verb. Either \dQuote{GET} or \dQuote{POST}.}

\item{body}{A character string specifying a request body (if \code{verb = "POST"}).}

\item{version}{A character string specifying an API version. Default is \dQuote{2010-05-08}.}

\item{region}{A character string specifying an AWS region. See \code{\link[aws.signature]{locate_credentials}}.}

\item{key}{A character string specifying an AWS Access Key. See \code{\link[aws.signature]{locate_credentials}}.}

\item{secret}{A character string specifying an AWS Secret Key. See \code{\link[aws.signature]{locate_credentials}}.}

\item{session_token}{Optionally, a character string specifying an AWS temporary Session Token to use in signing a request. See \code{\link[aws.signature]{locate_credentials}}.}

\item{\dots}{Additional arguments passed to \code{\link[httr]{GET}} or \code{\link[httr]{POST}}}
}
\description{
These are the low-level API querying functions for IAM and STS. Users do not need to use these directly.
}
