% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_update_capacity_provider}
\alias{ecs_update_capacity_provider}
\title{Update Capacity Provider}
\usage{
ecs_update_capacity_provider(
  name = NULL,
  autoScalingGroupProvider = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{name}{Character. The name of the capacity provider to update.}

\item{autoScalingGroupProvider}{Object. An object representing the parameters to update for the Auto Scaling group capacity provider.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modifies the parameters for a capacity
provider.
}
\section{name}{

The name of the capacity provider to
update.
}

\section{autoScalingGroupProvider}{

An object representing the parameters to
update for the Auto Scaling group capacity
provider.
}

